# coding: utf-8

import json
import re
import socket

import requests
from concurrent.futures import ThreadPoolExecutor
from tornado.escape import json_decode, json_encode
from tornado.concurrent import run_on_executor
import tornado.web
from app.base.controller import TPBaseHandler
from app.base.core_server import core_service_async_enc
from app.base.logger import *
from app.const import TP_PRIVILEGE_ASSET_CREATE, TPE_PARAM, TPE_OK, TPE_JSON_FORMAT, TP_AUTH_TYPE_PASSWORD, \
    TP_AUTH_TYPE_PRIVATE_KEY, TPE_EXISTS, TPE_FAILED, TPE_NOT_EXISTS
from app.model import account
from app.model import host
from app.model import plugin
from app.model.plugin import free_host


def current_ip():
    s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    s.connect(("8.8.8.8", 80))
    ip = s.getsockname()[0]
    s.close()
    return ip


def network_ip():
    req = requests.get("http://txt.go.sohu.com/ip/soip")
    ip = re.findall(r'\d+.\d+.\d+.\d+', req.text)[0]
    return ip


class TPBasePluginHandler(TPBaseHandler):
    """
    所有返回JSON数据的控制器均从本类继承，返回的数据格式一律包含三个字段：code/msg/data
    code: TPE_OK=成功，其他=失败
    msg: 字符串，一般用于code为非零时，指出错误原因
    data: 一般用于成功操作的返回的业务数据
    """
    executor = ThreadPoolExecutor(100)

    def __init__(self, application, request, **kwargs):
        super().__init__(application, request, **kwargs)
        self._mode = self.MODE_JSON
        self.local_ip = current_ip()
        self.outer_ip = network_ip()

    async def prepare(self):
        # req = requests.get("http://txt.go.sohu.com/ip/soip")
        # ip = re.findall(r'\d+.\d+.\d+.\d+', req.text)[0]
        # self.request.remote_ip
        _user = self.get_session('user')
        if _user is None:
            _user = {
                'id': 0,
                'username': 'guest',
                'surname': '访客',
                'role_id': 0,
                'role': '访客',
                'privilege': TP_PRIVILEGE_ASSET_CREATE,
                '_is_login': False
            }
        self._user = _user

        if not self.control_ip(self.request.remote_ip):
            raise tornado.web.HTTPError(404)

    def get_payload(self):
        log.i(self.request.body)
        log.i('\n')
        return json_decode(self.request.body)

    def check_ip(self, props):
        ip = props.get("ip", "")
        if ip and not re.findall(r'\d+\.\d+\.\d+\.\d+', ip):
            return False
        else:
            return True

    def control_ip(self, ip):
        items = ip.split(".")[:2]
        if items == self.outer_ip.split(".")[:2] or items == self.local_ip.split(".")[:2]:
            return True
        else:
            return False

    def finish_json(self, code, msg="成功", data: list = None):
        _ret = {"res": 1 if not code else 0, "ec": code, "msg": msg}
        if data:
            _ret["dt"] = {"lst": data}
        self.set_header("Content-Type", "application/json")
        log.i(_ret)
        log.i('\n')
        self.write(json_encode(_ret))
        self.finish()
        return

    @run_on_executor
    def request_api(self, url, data=None, json=None):
        _user = {'id': 1, 'type': 1, 'auth_type': 2, 'username': 'admin', 'surname': 'admin', 'ldap_dn': '',
                 'role_id': 1,
                 'state': 1, 'fail_count': 0, 'lock_time': 0, 'email': '929749555@qq.com', 'create_time': 1583104533,
                 'last_login': 1583788567, 'last_ip': '172.30.10.106', 'last_chpass': 1583104533, 'mobile': '',
                 'qq': '',
                 'wechat': '', 'desc': '', 'role': '系统管理员', 'privilege': 4294967295, '_is_login': True}
        self._s_id = "tp_1583808860_5c0a3c718114f429"
        self.set_session('user', _user, 12 * 60 * 60)
        cookies = {"_sid": self._s_id, "username": "admin"}
        resp = requests.post(url, data=data, json=json, cookies=cookies)
        return resp.json()


class UpdateHostHandler(TPBasePluginHandler):
    def insert_host(self):
        args = self.get_argument('args', None)

        try:
            args = json.loads(args)
        except:
            return TPE_PARAM

        if len(args['ip']) == 0:
            return TPE_PARAM

        if args['id'] == -1:
            err, info = host.add_host(self, args)
        else:
            err = host.update_host(self, args)
            info = 0

        return err, info

    def insert_account(self):
        args = self.get_argument('args', None)
        if args is None:
            return self.write_json(TPE_PARAM)
        try:
            args = json.loads(args)
        except:
            return self.write_json(TPE_JSON_FORMAT)

        try:
            host_id = int(args['host_id'])
            acc_id = int(args['acc_id'])
        except:
            log.e('\n')
            return self.write_json(TPE_PARAM)

        try:
            param = dict()
            param['host_ip'] = args['param']['host_ip']
            param['router_ip'] = args['param']['router_ip']
            param['router_port'] = args['param']['router_port']
            param['protocol_type'] = int(args['param']['protocol'])
            param['protocol_port'] = int(args['param']['port'])
            param['auth_type'] = int(args['param']['auth_type'])
            param['username'] = args['param']['username'].strip()
            param['password'] = args['param']['password']
            param['pri_key'] = args['param']['pri_key'].strip()
            param['username_prompt'] = args['param']['username_prompt'].strip()
            param['password_prompt'] = args['param']['password_prompt'].strip()
        except:
            log.e('\n')
            return self.write_json(TPE_PARAM)

        if len(param['username']) == 0:
            return self.write_json(TPE_PARAM)

        if acc_id == -1:
            # 新增账号
            if param['auth_type'] == TP_AUTH_TYPE_PASSWORD and len(param['password']) == 0:
                return self.write_json(TPE_PARAM)
            elif param['auth_type'] == TP_AUTH_TYPE_PRIVATE_KEY and len(param['pri_key']) == 0:
                return self.write_json(TPE_PARAM)

        if acc_id == -1:
            err, info = account.add_account(self, host_id, param)
        else:
            err = account.update_account(self, host_id, acc_id, param)
            info = {}

        return err, info

    def generate_assets_num(self, ip):
        data = ip.split('.')
        data = ['%03d' % int(i) for i in data]
        return ''.join(data)

    @tornado.gen.coroutine
    def post(self):
        # todo 数据处理不同步
        props = self.get_payload()

        if not self.check_ip(props):
            self.finish_json(1001, "IP不符合规范")
            return

        os_type = props.pop("os_type", 0)
        ip = props.pop("ip", "")
        username = props.pop("username", "")
        password = props.pop("password", 0)
        name = props.pop("name", "")
        desc = props.pop("desc", "")
        host_id = props.pop("host_id", 0)
        app_id = props.pop("app_id", 0)
        status = props.get("status", 0)

        # “res”:1,“ec”:”0”,“msg”:”成功”
        if not os_type or not ip or not username or not password:
            self.finish_json(1001, "缺少必要参数异常")
            return

        assets_num = self.generate_assets_num(ip)

        args = {"id": -1, "os_type": os_type, "ip": ip, "router_ip": "", "router_port": 0, "name": "",
                "cid": assets_num,
                "desc": ""}

        args = json.dumps(args).encode()
        self.request.arguments = {'args': [args]}

        # 添加主机
        err, info = self.insert_host()

        # 相同主机不允许重复添加
        if err == TPE_EXISTS:
            self.finish_json(1003, "已存在主机，不可重复添加")
            return

        code, ret_data = yield core_service_async_enc(password)
        if code != TPE_OK:
            return self.write_json(code)

        host_id = info
        args = {"host_id": host_id, "acc_id": -1,
                "param": {"host_ip": ip, "router_ip": "", "router_port": 0, "protocol": 1, "port": 3389,
                          "auth_type": 1, "username": username, "password": ret_data, "pri_key": "",
                          "username_prompt": "", "password_prompt": ""}}
        args = json.dumps(args).encode()

        # 添加用户
        self.request.arguments = {'args': [args]}

        err, info = self.insert_account()

        if info > 0:
            args = {"host_id": host_id, "name": name, "ip": ip, "remark": desc, "username": username,
                    "password": ret_data, "assets_num": assets_num, "os_type": os_type, "status": status}
            plugin.add_remote_host(self, args)
            self.finish_json(0, "成功")
        else:
            self.finish_json(1003, "设备添加异常")

    def put(self):
        props = self.get_payload()
        log.i(props)

        if not self.check_ip(props):
            self.finish_json(1001, "IP不符合规范")
            return

        os_type = props.get("os_type", 0)
        ip = props.get("ip", "")
        username = props.get("username", "")
        password = props.get("password", 0)
        name = props.get("name", "")
        desc = props.get("desc", "")
        host_id = props.get("host_id", 0)
        status = props.get("status", 0)

        # “res”:1,“ec”:”0”,“msg”:”成功”
        if not os_type or not ip or not username or not password:
            self.finish_json(1001, "缺少必要参数异常")
            return

        args = {"os_type": os_type, "ip": ip, "username": username, "password": password, "name": name, "remark": desc,
                "id": host_id, "assets_num": "", "status": status}

        # 调用更新接口
        err = plugin.update_host(self, args)
        # 已经存在数据库

        self.finish_json(0, "成功")


class GetHostListHandler(TPBasePluginHandler):
    def post(self):
        props = self.get_payload()
        args = self.get_payload()
        log.i(props)
        os_type = props.pop("os_type", 0)
        ip = props.pop("ip", "")
        search = props.pop("search", "")
        status = props.pop("status", 0)
        app_id = props.pop("app_id", 0)

        sql_filter = {}
        sql_order = dict()
        sql_order['name'] = 'id'
        sql_order['asc'] = True
        sql_limit = dict()
        sql_limit['page_index'] = 0
        sql_limit['per_page'] = 25
        sql_restrict = {}
        sql_exclude = {}

        _limit = args.get('limit', {"page_index": 0, "per_page": 0})
        if _limit['page_index'] < 0:
            _limit['page_index'] = 0
        if _limit['per_page'] < 10:
            _limit['per_page'] = 10
        if _limit['per_page'] > 100:
            _limit['per_page'] = 100

        sql_limit.update(_limit)

        _order = args.get("order")
        if _order is not None:
            sql_order['name'] = _order['k']
            sql_order['asc'] = _order['v']

        err, total_count, page_index, row_data = \
            plugin.get_host_list(sql_limit, os_type, ip, search, status)
        ret = dict()
        ret['page_index'] = page_index
        ret['total'] = total_count
        ret['data'] = row_data

        for item in row_data:
            item['desc'] = item.pop("remark", "")
            item['host_id'] = item.pop("id", 0)
            # 绑定详情
            # todo 使用公用方法
            item['bind'] = plugin.get_bind_info(item['host_id'])

        self.finish_json(0, data=row_data)


class GetHostInfoHandler(TPBasePluginHandler):
    def post(self):
        props = self.get_payload()
        host_id = props.pop("host_id", 0)
        mch_no = props.pop("mch_no", "")

        err, host_info = plugin.get_account_info(host_id=host_id, mch_no=mch_no)
        if err != TPE_OK:
            self.write(json_encode({"res": 0, "ec": "1004", "msg": "设备信息获取异常"}))
            self.finish()
            return

        host_info['desc'] = host_info.pop("remark", "")
        host_info['host_id'] = host_info.pop("id", 0)

        self.finish_json(0, data=[host_info])


class GetSessionInfoHandler(TPBasePluginHandler):
    async def post(self):
        props = self.get_payload()
        log.i(json.dumps(props))

        if not self.check_ip(props):
            self.finish_json(1001, "IP不符合规范")
            return

        host_id = props.pop("host_id", 0)
        mch_no = props.pop("mch_no", "")

        ip = props.pop("ip", "")
        username = props.pop("username", 0)
        password = props.pop("password", 0)
        data = {"ip": ip, "os_type": 1, "username": username, "password": password}
        url = "http://127.0.0.1:7190/plugin/update_host"
        await self.request_api(url, json=data)

        err, info = plugin.get_session_info(host_id, mch_no, ip)
        url = "http://127.0.0.1:7190/ops/get-session-id"

        args = {"args": json.dumps(
            {"mode": 2, "auth_id": "none", "acc_id": info, "host_id": host_id, "protocol_type": 1,
             "protocol_sub_type": 100, "rdp_width": 0, "rdp_height": 0, "rdp_console": False}).encode()}

        # 带信息带先插入
        resp = await self.request_api(url, args)

        if isinstance(resp, dict):
            ip = ip or plugin.get_host_ip(host_id)
            resp = {"teleport_ip": "172.30.10.104", "teleport_port": 52089, "remote_host_ip": ip,
                    "session_id": resp.get("session_id"), "protocol_type": 1, "protocol_sub_type": 100,
                    "protocol_flag": resp.get("protocol_flag"), "rdp_width": 0, "rdp_height": 0, "rdp_console": False}

        self.finish_json(0, data=[resp])
        return


class BindPayAccountHandler(TPBasePluginHandler):
    async def post(self):
        props = self.get_payload()
        args = props

        if not self.check_ip(props):
            self.finish_json(1001, "IP不符合规范")
            return

        biz_id = props.get("biz_id", 0)
        host_assigned = props.get("host_assigned") or 0
        host_id = props.get("host_id", 0)

        if not biz_id:
            self.finish_json(1001, "缺少必要参数异常：biz_id")
            return

        if host_assigned == 1:
            # 自动分配功能
            err, info = free_host()
            if err == TPE_OK:
                args['host_id'] = info
            else:
                self.finish_json(1010, "未发现空闲主机")
                return

        args = {"args": json.dumps(
            {"id": -1, "role": 2, "auth_type": 0, "username": str(biz_id), "surname": "", "email": "", "mobile": "",
             "qq": "", "wechat": "", "desc": ""}).encode()}

        url = 'http://127.0.0.1:7190/user/update-user'
        # biz 创建对象
        resp = await self.request_api(url, args)
        # {'code': 0, 'message': '', 'data': []}
        # {'code': 8, 'message': '', 'data': []} 已存在
        url = "http://172.30.10.104:7190/ops/policy/update"
        args = {"args": json.dumps({"id": -1, "name": str(biz_id), "desc": ""})}
        # 创建权限组
        resp = await self.request_api(url, args)
        # {'code': 0, 'message': '', 'data': []}
        # {'code': 8, 'message': '', 'data': 0}  已存在
        # 查询设备并自动赋权
        # url = "http://172.30.10.104:7190/ops/policy/add-members"
        # args = {"args": json.dumps({"policy_id": 1, "type": 0, "rtype": 1, "members": [{"id": 3, "name": "123456"}]})}
        # resp = await self.request_api(url, args)

        # args = {"args": json.dumps(
        #     {"policy_id": 1, "type": 1, "rtype": 5, "members": [{"id": 21, "name": "119.28.116.176"}]})}
        # resp = await self.request_api(url, args)
        args = props
        args['username'] = args.get("account") or ""
        args['host_assigned'] = args.get("host_assigned") or 0
        err, info = plugin.add_account_host_bind(self, args)

        self.finish_json(0)

    def put(self):
        props = self.get_payload()
        args = props

        if not self.check_ip(props):
            self.finish_json(1001, "IP不符合规范")
            return

        args['username'] = args.get("account") or ''
        args['host_assigned'] = args.get("host_assigned") or 0
        err = plugin.update_account_host_bind(self, args)
        if err == TPE_FAILED:
            self.finish_json(1011, "不允许修改公司资质")
            return
        elif err == TPE_NOT_EXISTS:
            self.finish_json(1012, "设备不存在")
        elif err == TPE_OK:
            self.finish_json(0)


class AccountStatusHandler(TPBasePluginHandler):
    def post(self):
        prop = self.get_payload()
        mch_name = prop.get("mch_name", "")
        login_status = prop.get("login_status", "")


class AccountInfoHandler(TPBasePluginHandler):
    def post(self):
        prop = self.get_payload()
        info = prop.get("info")

        accounts = plugin.query('remote_account_host_bind', ['username', 'password'],
                                'account_source=0 and ip={}'.format(info))
        accounts = {item[0]: item[1] for item in accounts}
        self.finish_json(0, data=[accounts])
