package com.example.allApi.ui.simBoxApi.queryDeviceList

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.text.method.ScrollingMovementMethod
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.lifecycle.ViewModelProvider
import com.example.allApi.data.Status
import com.example.allApi.data.ViewModelFactory
import com.example.allApi.data.ViewModelRepository
import com.example.allApi.data.api.ApiClient
import com.example.allApi.databinding.ActivitySimBoxQueryDeviceListBinding
import com.example.allApi.utils.StreamNoUtil
import com.google.gson.GsonBuilder

class SimBoxQueryDeviceListActivity : AppCompatActivity(), View.OnClickListener {

    companion object {
        fun intentToQueryDeviceListActivity(context: Context) {
            val intent = Intent(context, SimBoxQueryDeviceListActivity::class.java)
            context.startActivity(intent)
        }
    }

    private val mVB by lazy { ActivitySimBoxQueryDeviceListBinding.inflate(layoutInflater) }
    private lateinit var mQueryDeviceListViewModel: SimBoxQueryDeviceListViewModel

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(mVB.root)
        initViewModel()
        initView()
    }

    override fun onClick(view: View?) {
        when (view) {
            mVB.btnQueryDevicePostApi -> {

                val deviceType = ""
                val loginCustomerId = "6209e2ea1b7f0d319febe2b2"
                val partnerCode = "GCGROUP"
                val streamNo = "SIMBOX${StreamNoUtil.getData()}${((Math.random() * 9.toDouble() + 1.toDouble()) * 100000.toDouble()).toInt()}"

                val cookie = "access_token=TGT-2398391-2usdACdYsxPGbfXXnenVOIYRu6fZKFdZHpEAHczU0Sc4BfUZZR"
                val voidId = "80000076419"
                val userLabel = "businessUser"

                apiPostQueryDeviceList(deviceType, loginCustomerId, partnerCode, streamNo, cookie, voidId, userLabel)
            }
        }
    }

    private fun initViewModel() {
        val viewModelRepository: ViewModelRepository = ViewModelRepository.getInstance(ApiClient.getInstance(this).apiService)
        mQueryDeviceListViewModel = ViewModelProvider(this, ViewModelFactory.getInstance(viewModelRepository))[SimBoxQueryDeviceListViewModel::class.java]
    }

    private fun initView() {
        mVB.tvQueryDevicePostApi.movementMethod = ScrollingMovementMethod()
        mVB.btnQueryDevicePostApi.setOnClickListener(this)
    }

    private fun apiPostQueryDeviceList(
        deviceType: String, loginCustomerId: String, partnerCode: String, streamNo: String,
        cookie: String, voipId: String, userLabel: String
    ) {
        mQueryDeviceListViewModel.apiPostQueryDeviceList(deviceType, loginCustomerId, partnerCode, streamNo, cookie, voipId, userLabel).observe(this) {
            when (it.status) {
                Status.SUCCESS -> {
                    if (it.data?.resultCode == "00000000") {
                        val data = GsonBuilder().setPrettyPrinting().create().toJson(it.data)
                        mVB.tvQueryDevicePostApi.text = data
                        return@observe
                    }
                    mVB.tvQueryDevicePostApi.text = it.data?.resultDesc ?: ""
                }
                Status.ERROR -> {
                    mVB.tvQueryDevicePostApi.text = it.e?.message.toString()
                }
                Status.LOADING -> {

                }
            }
        }
    }
}