package com.example.allApi.ui.simBoxApi.queryCountryInfo

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.text.method.ScrollingMovementMethod
import android.view.View
import androidx.lifecycle.ViewModelProvider
import com.example.allApi.base.BaseActivity
import com.example.allApi.data.Status
import com.example.allApi.data.ViewModelFactory
import com.example.allApi.data.ViewModelRepository
import com.example.allApi.data.api.ApiClient
import com.example.allApi.databinding.ActivitySimBoxQueryCountryInfoBinding
import com.example.allApi.utils.StreamNoUtil
import com.google.gson.GsonBuilder

class SimBoxQueryCountryInfoActivity : BaseActivity(), View.OnClickListener {

    companion object {
        fun intentToQueryCountryInfo(context: Context) {
            val intent = Intent(context, SimBoxQueryCountryInfoActivity::class.java)
            context.startActivity(intent)
        }
    }

    private val mVB by lazy { ActivitySimBoxQueryCountryInfoBinding.inflate(layoutInflater) }
    private lateinit var mQueryCountryInfo: SimBoxQueryCountryInfoViewModel

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(mVB.root)
        initViewModel()
        initView()
    }

    override fun onClick(view: View?) {
        when (view) {
            mVB.btnQueryCountryPostApi -> {
                mVB.tvQueryCountryResponse.text = ""

                val langType = "zh-CN"
                val loginCustomerId = ""
                val partnerCode = "GCGROUP"
                val streamNo = "SIMBOX${StreamNoUtil.getData()}${((Math.random() * 9.toDouble() + 1.toDouble()) * 100000.toDouble()).toInt()}"

                val cookie = "access_token="
                val voipId = ""

                apiPostQueryCountry(langType, loginCustomerId, partnerCode, streamNo, cookie, voipId)
            }
        }
    }

    private fun initViewModel() {
        val viewModelRepository: ViewModelRepository = ViewModelRepository.getInstance(ApiClient.getInstance(this).apiService)
        mQueryCountryInfo = ViewModelProvider(this, ViewModelFactory.getInstance(viewModelRepository))[SimBoxQueryCountryInfoViewModel::class.java]
    }

    private fun initView() {
        mVB.tvQueryCountryResponse.movementMethod = ScrollingMovementMethod()
        mVB.btnQueryCountryPostApi.setOnClickListener(this)
    }

    private fun apiPostQueryCountry(langType: String, loginCustomerId: String, partnerCode: String, streamNo: String, cookie: String, voipId: String) {
        mQueryCountryInfo.apiPostQueryCountryInfo(langType, loginCustomerId, partnerCode, streamNo, cookie, voipId).observe(this) {
            when (it.status) {
                Status.SUCCESS -> {
                    if (it.data?.resultCode == "00000000") {
                        val data = GsonBuilder().setPrettyPrinting().create().toJson(it.data)
                        mVB.tvQueryCountryResponse.text = data
                        return@observe
                    }
                    mVB.tvQueryCountryResponse.text = it.data?.resultDesc ?: ""
                }
                Status.ERROR -> {
                    mVB.tvQueryCountryResponse.text = it.e?.message.toString()
                }
                Status.LOADING -> {

                }
            }
        }
    }

}