package com.example.allApi.ui.simBoxApi

import android.content.Context
import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.view.View
import com.example.allApi.databinding.ActivitySimBoxApiBinding
import com.example.allApi.ui.simBoxApi.changeSim.SimBoxChangeActivity
import com.example.allApi.ui.simBoxApi.login.SimBoxLoginActivity
import com.example.allApi.ui.simBoxApi.queryCountryInfo.SimBoxQueryCountryInfoActivity
import com.example.allApi.ui.simBoxApi.queryDeviceList.SimBoxQueryDeviceListActivity

class SimBoxApiActivity : AppCompatActivity(), View.OnClickListener {

    private val mVB by lazy { ActivitySimBoxApiBinding.inflate(layoutInflater) }

    companion object {
        fun intentToSimBoxApiActivity(content: Context) {
            val intent = Intent(content, SimBoxApiActivity::class.java);
            content.startActivity(intent)
        }
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(mVB.root)
        initView()

    }

    override fun onClick(v: View?) {
        when (v) {
            mVB.btnSimBoxQueryCountry -> {
                SimBoxQueryCountryInfoActivity.intentToQueryCountryInfo(this)
            }
            mVB.btnSimBoxLogin -> {
                SimBoxLoginActivity.intentToLogin(this)
            }
            mVB.btnSimBoxChangeSim -> {
                SimBoxChangeActivity.intentToChangeSimActivity(this)
            }
            mVB.btnSimBoxQueryDevicesList -> {
                SimBoxQueryDeviceListActivity.intentToQueryDeviceListActivity(this)
            }
        }
    }

    private fun initView() {
        mVB.btnSimBoxQueryCountry.setOnClickListener(this)
        mVB.btnSimBoxLogin.setOnClickListener(this)
        mVB.btnSimBoxChangeSim.setOnClickListener(this)
        mVB.btnSimBoxQueryDevicesList.setOnClickListener(this)
    }
}