package com.example.allApi.data

import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import com.example.allApi.ui.simBoxApi.changeSim.SimBoxChangeViewModel
import com.example.allApi.ui.simBoxApi.queryCountryInfo.SimBoxQueryCountryInfoViewModel
import com.example.allApi.ui.simBoxApi.queryDeviceList.SimBoxQueryDeviceListViewModel
import java.lang.IllegalArgumentException

class ViewModelFactory(private val viewModelRepository: ViewModelRepository) : ViewModelProvider.Factory {

    companion object {
        fun getInstance(viewModelRepository: ViewModelRepository): ViewModelFactory {
            return ViewModelFactory(viewModelRepository)
        }
    }

    override fun <T : ViewModel> create(modelClass: Class<T>): T {
        return when {
            modelClass.isAssignableFrom(SimBoxQueryCountryInfoViewModel::class.java) -> SimBoxQueryCountryInfoViewModel(viewModelRepository) as T
            modelClass.isAssignableFrom(SimBoxChangeViewModel::class.java) -> SimBoxChangeViewModel(viewModelRepository) as T
            modelClass.isAssignableFrom(SimBoxQueryDeviceListViewModel::class.java) -> SimBoxQueryDeviceListViewModel(viewModelRepository) as T
            else -> throw IllegalArgumentException("unKnow class name")
        }

    }

}