package com.example.simboxapi.ui.changeSim

import android.content.Context
import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.text.method.ScrollingMovementMethod
import android.view.View
import androidx.lifecycle.ViewModelProvider
import cn.hutool.json.JSON
import com.example.simboxapi.data.Status
import com.example.simboxapi.data.ViewModelFactory
import com.example.simboxapi.data.ViewModelRepository
import com.example.simboxapi.data.api.ApiClient
import com.example.simboxapi.databinding.ActivityChangeSimBinding
import com.example.simboxapi.utils.DatePattern
import com.example.simboxapi.utils.StreamNoUtil
import com.google.gson.GsonBuilder
import org.json.JSONObject
import java.text.SimpleDateFormat
import java.util.*
import kotlin.collections.ArrayList

class ChangeSimActivity : AppCompatActivity(), View.OnClickListener {

    companion object {
        fun intentToChangeSimActivity(context: Context) {
            val intent = Intent(context, ChangeSimActivity::class.java)
            context.startActivity(intent)
        }
    }

    private val mVB: ActivityChangeSimBinding by lazy { ActivityChangeSimBinding.inflate(layoutInflater) }
    private lateinit var mChangeSimViewModel: ChangeSimViewModel

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(mVB.root)
        setViewModel()
        initView()
    }

    override fun onClick(view: View?) {
        when (view) {
            mVB.btnChangeSimPostApi -> {
                mVB.tvChangSimContent.text = ""

                val imei = "864055040488792"
                val loginCustomId = "6209e2ea1b7f0d319febe2b2"
                val offImsiList = arrayListOf("460015466225468")
                val onImsiList = arrayListOf<String>()
                val partnerCode = "GCGROUP"
                val streamNo = "SIMBOX${StreamNoUtil.getData()}${((Math.random() * 9.toDouble() + 1.toDouble()) * 100000.toDouble()).toInt()}"

                val cookie = "access_token=TGT-2398391-2usdACdYsxPGbfXXnenVOIYRu6fZKFdZHpEAHczU0Sc4BfUZZR"
                val voidId = "80000076419"
                val userLabel = "businessUser"

                apiPostOnOffImsi(imei, loginCustomId, offImsiList, onImsiList, partnerCode, streamNo, cookie, voidId, userLabel)
            }
        }
    }

    private fun setViewModel() {
        val viewModelRepository: ViewModelRepository = ViewModelRepository.getInstance(ApiClient.getInstance(this).apiService)
        mChangeSimViewModel = ViewModelProvider(this, ViewModelFactory.getInstance(viewModelRepository))[ChangeSimViewModel::class.java]
    }

    private fun initView() {
        mVB.tvChangSimContent.movementMethod = ScrollingMovementMethod()
        mVB.btnChangeSimPostApi.setOnClickListener(this)
    }

    private fun apiPostOnOffImsi(imei: String, loginCustomId: String, offImsiList: ArrayList<String>, onImsiList: ArrayList<String>, partnerCode: String, streamNo: String, cookie: String, voipId: String, userLabel: String) {
        mChangeSimViewModel.apiPostOnOffImsi(imei, loginCustomId, offImsiList, onImsiList, partnerCode, streamNo, cookie, voipId, userLabel).observe(this) {
            when (it.status) {
                Status.SUCCESS -> {
                    if (it.data?.resultCode == "00000000") {
                        val data = GsonBuilder().setPrettyPrinting().create().toJson(it.data)
                        mVB.tvChangSimContent.text = data
                        return@observe
                    }
                    mVB.tvChangSimContent.text = it.data?.resultDesc ?: ""
                }
                Status.ERROR -> {
                    mVB.tvChangSimContent.text = it.e?.message.toString()
                }
                Status.LOADING -> {

                }
            }
        }
    }

}
