package com.example.allApi.ui.jlPay

import android.content.Context
import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.view.View
import com.example.allApi.databinding.ActivityJlPayBinding
import com.example.allApi.ui.jlPay.getImageCode.JlPayGetImageCodeActivity

class JlPayActivity : AppCompatActivity(), View.OnClickListener {

    private val mVB by lazy { ActivityJlPayBinding.inflate(layoutInflater) }

    companion object {
        fun intentToJlPayActivity(context: Context) {
            val intent = Intent(context, JlPayActivity::class.java)
            context.startActivity(intent)
        }
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(mVB.root)
        initView()
    }

    override fun onClick(v: View?) {
        when (v) {
            mVB.btnJlPayGetImageCode -> {
                JlPayGetImageCodeActivity.intentToJlPayGetImageCodeActivity(this)
            }
        }
    }

    private fun initView() {
        mVB.btnJlPayGetImageCode.setOnClickListener(this)
    }
}