package com.example.allApi.ui

import android.os.Bundle
import android.view.View
import com.example.allApi.base.BaseActivity
import com.example.allApi.databinding.ActivityMainBinding
import com.example.allApi.ui.jlPay.JlPayActivity
import com.example.allApi.ui.simBoxApi.SimBoxApiActivity

class MainActivity : BaseActivity(), View.OnClickListener {

    private val mVB by lazy { ActivityMainBinding.inflate(layoutInflater) }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(mVB.root)
        initView()
    }

    override fun onClick(view: View?) {
        when (view) {
            mVB.btnMainSimBox -> {
                SimBoxApiActivity.intentToSimBoxApiActivity(this)
            }
            mVB.btnMainJlPay -> {
                JlPayActivity.intentToJlPayActivity(this)
            }
        }
    }

    private fun initView() {
        mVB.btnMainSimBox.setOnClickListener(this)
        mVB.btnMainJlPay.setOnClickListener(this)
    }
}