package com.example.simboxapi.data.api

import android.content.Context
import com.example.simboxapi.Constants
import okhttp3.OkHttpClient
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import java.util.concurrent.TimeUnit

class ApiSystemClient(val context: Context) {

    val apiSystemService: ApiSystemService by lazy { provideApiService() }

    companion object {

        const val CONNECTION_TIME_OUT = 20000L
        const val WRITE_TIME_OUT = 20000L
        const val READ_TIME_OUT = 20000L

        fun getInstance(context: Context): ApiSystemClient = ApiSystemClient(context.applicationContext)
    }

    private fun provideOkHttpClient(): OkHttpClient {
        return OkHttpClient.Builder().run {
            addInterceptor(SystemUrlInterceptor.getInstance())
            connectTimeout(CONNECTION_TIME_OUT, TimeUnit.MILLISECONDS)
            writeTimeout(WRITE_TIME_OUT, TimeUnit.MILLISECONDS)
            readTimeout(READ_TIME_OUT, TimeUnit.MILLISECONDS)
            build()
        }
    }

    private fun provideRetrofit(client: OkHttpClient): Retrofit {
        return Retrofit.Builder().run {
            baseUrl(Constants.BASE_URL)
            client(client)
            addConverterFactory(GsonConverterFactory.create())
            build()
        }
    }

    private fun provideApiService(): ApiSystemService {
        val okHttpClient = provideOkHttpClient()
        val retrofit = provideRetrofit(okHttpClient)
        return retrofit.create(ApiSystemService::class.java)
    }
}