package com.example.simboxapi.ui

import android.os.Bundle
import android.view.View
import com.example.simboxapi.base.BaseActivity
import com.example.simboxapi.databinding.ActivityMainBinding
import com.example.simboxapi.ui.changeSim.ChangeSimActivity
import com.example.simboxapi.ui.login.LoginActivity
import com.example.simboxapi.ui.queryCountryInfo.QueryCountryInfoActivity
import com.example.simboxapi.ui.queryDeviceList.QueryDeviceListActivity

class MainActivity : BaseActivity(), View.OnClickListener {

    private val mVB by lazy { ActivityMainBinding.inflate(layoutInflater) }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(mVB.root)
        initView()
    }

    override fun onClick(view: View?) {
        when (view) {
            mVB.btnMainQueryCountry -> {
                QueryCountryInfoActivity.intentToQueryCountryInfo(this)
            }
            mVB.btnMainLogin -> {
                LoginActivity.intentToLogin(this)
            }
            mVB.btnMainChangeSim -> {
                ChangeSimActivity.intentToChangeSimActivity(this)
            }
            mVB.btnMainQueryDevicesList -> {
                QueryDeviceListActivity.intentToQueryDeviceListActivity(this)
            }
        }
    }

    private fun initView() {
        mVB.btnMainQueryCountry.setOnClickListener(this)
        mVB.btnMainLogin.setOnClickListener(this)
        mVB.btnMainChangeSim.setOnClickListener(this)
        mVB.btnMainQueryDevicesList.setOnClickListener(this)
    }
}