package com.example.simboxapi.data.api

import android.util.Log
import com.example.simboxapi.Constants
import okhttp3.HttpUrl
import okhttp3.HttpUrl.Companion.toHttpUrlOrNull
import okhttp3.Interceptor
import okhttp3.Response

class BaseUrlInterceptor : Interceptor {

    companion object {
        private val TAG = BaseUrlInterceptor::class.java.simpleName.toString()
        fun getInstance(): BaseUrlInterceptor = BaseUrlInterceptor()
    }

    override fun intercept(chain: Interceptor.Chain): Response {

        val request = chain.request()       //获取 request
        val oldHttpUrl = request.url        //从 request 中获取原有的 HttpUrl 实例 oldHttpUrl
        val builder = request.newBuilder()  //获取 request 的创建 builder

        //刪除原本的 url, 獲取新的 BaseUrl
        builder.removeHeader("urlname")
        val newBaseUrl: HttpUrl? = Constants.BASE_URL.toHttpUrlOrNull()

        //重建新的 HttpUrl, 修改需要修改url的部份
        val newFullUrl = newBaseUrl?.let {
            oldHttpUrl.newBuilder()
                .host(it.host)
                .port(it.port)
                .build()
        }

        //重建这个 request 通过builder.url(newFullUrl).build() 然后返回一个 response 至此结束
        Log.d(TAG, "intercept: $newFullUrl")
        return chain.proceed(builder.url(newFullUrl!!).build())
    }
}