package com.example.simboxapi.data

import android.util.Log
import androidx.lifecycle.LiveData
import androidx.lifecycle.liveData
import com.example.simboxapi.base.BaseResponse
import com.example.simboxapi.data.api.ApiSystemService
import com.example.simboxapi.data.entirys.CountryDataBean
import kotlinx.coroutines.Dispatchers
import okhttp3.MediaType.Companion.toMediaTypeOrNull
import okhttp3.RequestBody.Companion.toRequestBody
import org.json.JSONObject
import java.lang.Exception

class ViewModelRepository(private val apiSystemService: ApiSystemService) {

    companion object {
        fun getInstance(apiSystemService: ApiSystemService): ViewModelRepository {
            return ViewModelRepository(apiSystemService)
        }
    }

    private fun <T> execute(function: suspend () -> T): LiveData<ResourceViewModel<T>> {
        return liveData(Dispatchers.IO) {
            emit(ResourceViewModel.loading(data = null))
            try {
                emit(ResourceViewModel.success(function()!!))
            } catch (e: Exception) {
                emit(ResourceViewModel.error(data = null, e = e))
                Log.d("TAG","Test")
            }
        }
    }

    fun apiPostQueryCountryInfo(langType: String, loginCustomerId: String, partnerCode: String, streamNo: String): LiveData<ResourceViewModel<BaseResponse<ArrayList<CountryDataBean>>>> {
        val jsonObject = JSONObject()
        jsonObject.put("langType", langType)
        jsonObject.put("loginCustomerId", loginCustomerId)
        jsonObject.put("partnerCode", partnerCode)
        jsonObject.put("streamNo", streamNo)
        val body = jsonObject.toString().toRequestBody("application/json".toMediaTypeOrNull())
        return execute { apiSystemService.apiQueryCountryInfo(body) }
    }

}