package com.example.simboxapi.ui.queryCountryInfo

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.view.View
import androidx.lifecycle.ViewModelProvider
import com.example.simboxapi.base.BaseActivity
import com.example.simboxapi.data.Status
import com.example.simboxapi.data.ViewModelFactory
import com.example.simboxapi.data.ViewModelRepository
import com.example.simboxapi.data.api.ApiSystemClient
import com.example.simboxapi.databinding.ActivityQueryCountryInfoBinding
import com.example.simboxapi.utils.DatePattern
import java.text.SimpleDateFormat
import java.util.*

class QueryCountryInfoActivity : BaseActivity(), View.OnClickListener {

    companion object {
        fun intentToQueryCountryInfo(context: Context) {
            val intent = Intent(context, QueryCountryInfoActivity::class.java)
            context.startActivity(intent)
        }
    }

    private val mVB by lazy { ActivityQueryCountryInfoBinding.inflate(layoutInflater) }
    private lateinit var mQueryCountryInfo: QueryCountryInfoViewModel

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(mVB.root)
        setViewModel()
        initView()
    }

    override fun onClick(view: View?) {
        when (view) {
            mVB.btnQueryCountryPostApi -> {
                mVB.tvQueryCountryResponse.text = ""
                val langType = "zh-TW"
                val loginCustomerId = ""
                val partnerCode = "GCGROUP"
                val streamNo = "SIMBOX${getData()}${((Math.random() * 9.toDouble() + 1.toDouble()) * 100000.toDouble()).toInt()}"
                apiPostQueryCountry(langType,loginCustomerId,partnerCode, streamNo)
            }
        }
    }

    private fun setViewModel() {
        val viewModelRepository: ViewModelRepository = ViewModelRepository.getInstance(ApiSystemClient.getInstance(this).apiSystemService)
        mQueryCountryInfo = ViewModelProvider(this, ViewModelFactory.getInstance(viewModelRepository))[QueryCountryInfoViewModel::class.java]
    }

    private fun initView() {
        mVB.btnQueryCountryPostApi.setOnClickListener(this)
    }

    private fun getData(): String {
        val instance = Calendar.getInstance()
        val simpleDateFormat = SimpleDateFormat(DatePattern.PURE_DATETIME_MS_PATTERN, Locale.ENGLISH)
        simpleDateFormat.timeZone = TimeZone.getTimeZone("UTC")
        return simpleDateFormat.format(instance.time)
    }

    private fun apiPostQueryCountry(langType:String,loginCustomerId:String,partnerCode:String,streamNo:String){
        mQueryCountryInfo.apiPostQueryCountryInfo(langType, loginCustomerId, partnerCode, streamNo).observe(this) {
            when (it.status) {
                Status.SUCCESS -> {
                    mVB.tvQueryCountryResponse.text = it.data.toString()
                }
                Status.ERROR -> {
                    mVB.tvQueryCountryResponse.text = it.e?.message.toString()
                }
                Status.LOADING -> {

                }
            }
        }
    }

}