package com.example.simboxapi.data

import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import com.example.simboxapi.ui.changeSim.ChangeSimViewModel
import com.example.simboxapi.ui.queryCountryInfo.QueryCountryInfoViewModel
import java.lang.IllegalArgumentException

class ViewModelFactory(private val viewModelRepository: ViewModelRepository):ViewModelProvider.Factory {

    companion object{
        fun getInstance(viewModelRepository: ViewModelRepository):ViewModelFactory{
            return ViewModelFactory(viewModelRepository)
        }
    }

    override fun <T : ViewModel> create(modelClass: Class<T>): T {
        return when{
            modelClass.isAssignableFrom(QueryCountryInfoViewModel::class.java) -> QueryCountryInfoViewModel(viewModelRepository) as T
            modelClass.isAssignableFrom(ChangeSimViewModel::class.java) -> ChangeSimViewModel(viewModelRepository) as T
            else -> throw IllegalArgumentException("unKnow class name")
        }

    }

}