package com.go.hookNotify.xp.code;

import android.app.AndroidAppHelper;
import android.app.Notification;
import android.content.Context;
import android.os.Bundle;

import com.go.hookNotify.units.LogSaveUnit;
import com.go.hookNotify.units.XPoseDebugUnit;

import java.util.Set;

import de.robv.android.xposed.IXposedHookLoadPackage;
import de.robv.android.xposed.XC_MethodHook;
import de.robv.android.xposed.XposedHelpers;
import de.robv.android.xposed.callbacks.XC_LoadPackage;

public class HookGlobalNotify implements IXposedHookLoadPackage {

    private final String[] mAryStrBlackList = new String[]{"com.ucloudlink.simbox"};
    private Context mContext = null;

    @Override
    public void handleLoadPackage(XC_LoadPackage.LoadPackageParam lpparam) throws Throwable {

        final Class clazz = XposedHelpers.findClass("android.app.NotificationManager", lpparam.classLoader);
        XPoseDebugUnit.xPoseLogInfo("android hook NotificationManager start init!!" + clazz.getName());

        XposedHelpers.findAndHookMethod(clazz, "notify", String.class, int.class, Notification.class, new XC_MethodHook() {

            @Override
            protected void beforeHookedMethod(MethodHookParam param) throws Throwable {
                mContext = AndroidAppHelper.currentApplication();
                XPoseDebugUnit.xPoseLogInfo(mContext.toString());
                super.beforeHookedMethod(param);
            }

            @Override
            protected void afterHookedMethod(MethodHookParam param) throws Throwable {
                super.afterHookedMethod(param);

                if (lpparam == null) return;
                if (checkBlackList(lpparam.packageName)) {
                    XPoseDebugUnit.xPoseLogInfo("黑名单: " + lpparam.packageName);
                    return;
                }
                XPoseDebugUnit.xPoseLogInfo("非黑名单: " + lpparam.packageName);

                Notification notification = (Notification) param.args[2];
                StringBuilder sb = new StringBuilder();
                sb.append("\n").append("object notification: ").append(notification.toString()).append("\n");
                sb.append("object bundle:").append("\n");

                Bundle bundle = notification.extras;
                if (bundle != null) {
                    Set<String> keys = bundle.keySet();
                    for (String key : keys) {
                        sb.append(key).append(" : ").append(bundle.get(key)).append("\n");
                    }
                }
                XPoseDebugUnit.xPoseLogInfo(sb.toString());

                String title = notification.extras.getString("android.title", "no Title");
//                String content = notification.extras.getString("android.text", "");

                String documentName = "log/" + title;
//                LogSaveUnit.INSTANCE.saveLogFile(documentName, sb.toString());
            }
        });
    }

    /**
     * 判断是否为黑名单
     *
     * @param sPackageName 包名
     * @return true 为黑名单
     */
    private boolean checkBlackList(String sPackageName) {
        boolean isBlackList = false;
        for (String sBlackList : mAryStrBlackList) {
            if (sBlackList.equals(sPackageName)) {
                isBlackList = true;
                break;
            }
        }
        return isBlackList;
    }

}
