package com.go.hookNotify.units

import android.annotation.SuppressLint
import android.content.ContentValues
import android.content.Context
import android.net.Uri
import android.os.Build
import android.os.Environment
import android.provider.MediaStore
import android.util.Log
import java.io.*


object LogSaveUnit {

    val TAG = LogSaveUnit::class.java.simpleName.toString()

    fun saveLogFile(context: Context, documentPath: String, fileName: String, sContent: String) {
        XPoseDebugUnit.xPoseLogDebug("$TAG-start saveLogFile")
        when (Build.VERSION.SDK_INT) {
            in 0..28 -> {
                val destFile = File(
                    "${Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DOWNLOADS)}/$documentPath/",
                    fileName
                )
                save(destFile, sContent)
            }
            29 -> {

            }
            else -> {
                //val isHaveFile = checkFileHigherAndroidQ(context, fileName, sContent) ?: false
                //if (!isHaveFile) saveFileHigherAndroidQ(context, documentPath, fileName, sContent)
                saveFileHigherAndroidQ(context, documentPath, fileName, sContent)
            }
        }
    }

    /**
     *  android 版本 0..28(小於29)
     *  檢查文件是否存在
     */
    private fun checkFileLTAndroidQ(context: Context, saveFileName: String): String {
        var getSaveContent = ""
        val destFile = File(Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_PICTURES), saveFileName)
        val uri: Uri?
        if (destFile.exists()) uri = Uri.parse("file://" + destFile.absoluteFile) else return ""
        try {
            val fileDescriptor = uri?.let { context.contentResolver.openFileDescriptor(it, "r", null) }
            val inputStream = FileInputStream(fileDescriptor?.fileDescriptor)
            getSaveContent = inputStreamToString(inputStream)
        } catch (e: FileNotFoundException) {
            e.printStackTrace()
        }
        return getSaveContent
    }

    /**
     * android 版本 大於 29
     * 檢查文件是否存在
     */
    @SuppressLint("Range")
    private fun checkFileHigherAndroidQ(context: Context, saveFileName: String, content: String): Boolean? {
        val cr = context.contentResolver
        val contentUri = MediaStore.Files.getContentUri("external")

        val cursor = cr.query(contentUri, null, null, null, null)
        var uri: Uri? = null
        val columnIndexID: Int
        if (cursor?.count == 0) {
            XPoseDebugUnit.xPoseLogDebug("$TAG-no file")
            return null
        } else {
            columnIndexID = cursor?.getColumnIndexOrThrow(MediaStore.Files.FileColumns._ID)!!
            while (cursor.moveToNext()) {
                val fileID = cursor.getLong(columnIndexID)
                val fileName = cursor.getString(cursor.getColumnIndex(MediaStore.MediaColumns.DISPLAY_NAME))

                XPoseDebugUnit.xPoseLogDebug("$TAG-searchFileName=$fileName")
                XPoseDebugUnit.xPoseLogDebug("$TAG-saveFileName=$saveFileName")

                if (fileName == saveFileName) {
                    uri = Uri.withAppendedPath(contentUri, fileID.toString())
                    break
                }
            }
            if (uri == null) {
                XPoseDebugUnit.xPoseLogDebug("$TAG-no uri")
                return null
            } else {
                var outputStream: FileOutputStream? = null
                return try {
                    val fieldException = cr.openAssetFileDescriptor(uri, "r", null)
                    outputStream = FileOutputStream(fieldException?.fileDescriptor)
                    val byte = content.toByteArray()

                    outputStream.write(byte)
                    outputStream.flush()

//                    val inputStream = FileInputStream(fieldException?.fileDescriptor)
//                    val sUUID = inputStreamToString(inputStream)
//                    inputStream.close()

                    true
                } catch (e: IOException) {
                    XPoseDebugUnit.xPoseLogDebug("$TAG-${e.printStackTrace()}")
                    null
                } finally {
                    cursor.close()
                    outputStream?.let { closeOutputStream(it) }
                }
            }
        }
    }

    private fun closeOutputStream(vararg os: OutputStream) {
        for (i in os.indices) {
            try {
                os[i].close()
            } catch (e: IOException) {
                e.printStackTrace()
            }
        }
    }

    /**
     * android 0..28 版本
     * 储存文件
     */
    private fun save(file: File, content: String): Boolean {
        if (!createFile(file, true)) {
            Log.e("FileSaveUtil", "create or delete file <\$file> failed.")
            return false
        }
        var outStream: FileOutputStream? = null
        var ret: Boolean
        try {
            outStream = FileOutputStream(file)
            outStream.write(content.toByteArray())
            outStream.flush()
            ret = true
        } catch (e: Exception) {
            e.printStackTrace()
            ret = false
        } finally {
            try {
                outStream?.close()
            } catch (e: IOException) {
                // ignore
            }
        }
        return ret
    }

    /**
     *  android 版本大于29
     *  储存 文件
     */
    private fun saveFileHigherAndroidQ(context: Context, documentPath: String, fileName: String, content: String): Boolean {

        XPoseDebugUnit.xPoseLogDebug("$TAG-init")

        val resolver = context.contentResolver
        val value = ContentValues()
        value.put(MediaStore.MediaColumns.DISPLAY_NAME, fileName)
        value.put(MediaStore.MediaColumns.MIME_TYPE, "text/plain")
        value.put(MediaStore.MediaColumns.RELATIVE_PATH, "${Environment.DIRECTORY_DOCUMENTS}/$documentPath/")
        val uri = resolver.insert(MediaStore.Files.getContentUri("external"), value)
        var outputStream: OutputStream? = null

        XPoseDebugUnit.xPoseLogDebug("$TAG-start")

        return try {
            outputStream = uri?.let { context.contentResolver.openOutputStream(it) }
            outputStream?.let {
                it.write(content.toByteArray())
                it.flush()
                it.close()
            }
            XPoseDebugUnit.xPoseLogDebug("$TAG-true")
            true
        } catch (e: Exception) {
            XPoseDebugUnit.xPoseLogDebug("$TAG-${e.message.toString()}")
            false
        }

    }

    /**
     * 流 轉為 字符串
     * @param inputStream 流
     * @return 轉換完成的字符串
     */
    private fun inputStreamToString(inputStream: InputStream): String {
        val reader = BufferedReader(InputStreamReader(inputStream))
        val sb = StringBuilder()
        try {
            reader.use { r -> r.lineSequence().forEach { sb.append(it) } }
        } catch (e: IOException) {
            e.printStackTrace()
        } finally {
            try {
                inputStream.close()
            } catch (e: IOException) {
                e.printStackTrace()
            }
        }
        return sb.toString()
    }


    private fun createFile(file: File?, isDeleteOldFile: Boolean): Boolean {
        if (file == null) return false
        if (file.exists()) {
            if (isDeleteOldFile) {
                if (!file.delete()) return false
            } else return file.isFile
        }
        return if (!createDir(file.parentFile)) false else try {
            file.createNewFile()
        } catch (e: IOException) {
            false
        }
    }

    private fun createDir(file: File?): Boolean {
        if (file == null) return false
        return if (file.exists()) file.isDirectory else file.mkdirs()
    }


}