package com.go.hookNotify.xp.code;

import android.app.AndroidAppHelper;
import android.content.ContentValues;
import android.content.Context;

import com.go.hookNotify.units.DateUnit;
import com.go.hookNotify.units.LogSaveUnit;
import com.go.hookNotify.units.XPoseDebugUnit;
import com.go.hookNotify.xp.Constants;
import com.google.gson.Gson;

import org.json.JSONObject;

import java.util.FormatFlagsConversionMismatchException;
import java.util.Map;

import de.robv.android.xposed.IXposedHookLoadPackage;
import de.robv.android.xposed.XC_MethodHook;
import de.robv.android.xposed.XposedHelpers;
import de.robv.android.xposed.callbacks.XC_LoadPackage;

public class HookSimBoxNotify implements IXposedHookLoadPackage {

    private final String CLASS_SIP_PHONE_UTIL = "com.ucloudlink.simbox.util.SipPhoneUtil";
    private final String CLASS_DEVICE_UTIL = "com.ucloudlink.simbox.util.DeviceUtil";
    private final String CLASS_HTTP_SERVICE = "com.ucloudlink.sdk.http.HttpService";
    private final String CLASS_HTTP_UTIL_LOGIN_SDK_1 = "com.ucloudlink.simbox.http.HttpUtil$loginSDK$1";

    private final String mNumber = "number";
    private final String mImsi = "imsi";
    private final String mText = "text";
    private final String mStatus = "status";
    private final String mMsgFrom = "msgFrom";
    private final String mTime = "time";
    private final String mIsGroup = "isGroup";
    private final String mIsRead = "isRead";
    private final String mIsDelete = "isDelete";
    private final String mToken = "token";
    private final String mBusinessType = "businessType";
    private final String mExt = "ext";
    private final String mCountryCode = "countryCode";
    private final String mNormalizedNumber = "normalizedNumber";

    private Context mContext = null;

    @Override
    public void handleLoadPackage(XC_LoadPackage.LoadPackageParam lpparam) throws Throwable {

        if (!lpparam.processName.equals(Constants.SIMBOX_NAME)) return;

        XPoseDebugUnit.xPoseLogInfo("simBox start init!!");

        /*
         * 登入前所帶入的參數
         */
        XposedHelpers.findAndHookMethod(XposedHelpers.findClass(CLASS_HTTP_SERVICE, lpparam.classLoader), "loginV2", "com.ucloudlink.sdk.http.request.LoginReq", new XC_MethodHook() {
            @Override
            protected void beforeHookedMethod(MethodHookParam param) throws Throwable {
                String resultJson = new Gson().toJson(param.args[0]);
                JSONObject jsonObject = new JSONObject(resultJson);

                //可能會用到
                String deviceType = jsonObject.getString("deviceType");         //因為是 android 所以字串為 ANDROID
                String devsn = jsonObject.getString("devsn");                   //手機裝置本身的 唯一碼
                String imei = jsonObject.getString("imei");                     //跟imei一樣
                String userCode = jsonObject.getString("userCode");             //使用者的手機號碼
                String partnerCode = jsonObject.getString("partnerCode");       //幾乎每個api都會帶到, 都是一樣的
                String streamNo = jsonObject.getString("streamNo");             //這個最好是寫成程式碼, 打api時取得當下的時間形成字串

                //可能不會用到或看不懂的
                String autoLogin = jsonObject.getString("autoLogin");
                String channelType = jsonObject.getString("channelType");
                String clientId = jsonObject.getString("clientId");
                String clientSecret = jsonObject.getString("clientSecret");
                String countryCode = jsonObject.getString("countryCode");
                String enterpriseCode = jsonObject.getString("enterpriseCode");
                String ext = jsonObject.getString("ext");
                String golcalmeAccount = jsonObject.getString("golcalmeAccount");
                String hardwareVersion = jsonObject.getString("hardwareVersion");
                String loginType = jsonObject.getString("loginType");
                String mobileBrand = jsonObject.getString("mobileBrand");
                String num = jsonObject.getString("num");
                String password = jsonObject.getString("password");
                String pushPlatform = jsonObject.getString("pushPlatform");
                String sipType = jsonObject.getString("sipType");
                String softVersion = jsonObject.getString("softVersion");
                String systemVersion = jsonObject.getString("systemVersion");
                String timestamp = jsonObject.getString("timestamp");
                String token = jsonObject.getString("token");
                String tokenType = jsonObject.getString("tokenType");

                XPoseDebugUnit.xPoseLogInfo("resultJson=" + resultJson);
                super.beforeHookedMethod(param);
            }
        });

        /*
         *  登入成功後 取得的結果
         */
        XposedHelpers.findAndHookMethod(XposedHelpers.findClass(CLASS_HTTP_UTIL_LOGIN_SDK_1, lpparam.classLoader), "onSuccess", "com.ucloudlink.sdk.http.base.BSSResult", new XC_MethodHook() {
            @Override
            protected void beforeHookedMethod(MethodHookParam param) throws Throwable {
                String resultJson = new Gson().toJson(param.args[0]);
                JSONObject data = new JSONObject(resultJson).getJSONObject("data");
                JSONObject userLoginVO = data.getJSONObject("userLoginVO");
                JSONObject sipUserVO = data.getJSONObject("sipUserVO");

                String userID = userLoginVO.getString("userId");            //就是 loginCustomId
                String accessToken = userLoginVO.getString("accessToken");
                String sipCode = sipUserVO.getString("sipCode");            //就是 voipId

                XPoseDebugUnit.xPoseLogInfo("\n userId(loginCustomId)=" + userID +
                        "\n accessToken=" + accessToken +
                        "\n sipCode(voipId)=" + sipCode);

                super.beforeHookedMethod(param);
            }
        });

        /*
         *  因为还有其他的api在使用同一组UUID, 所以替换位置更改为更上游的地方
         */
        XposedHelpers.findAndHookMethod(XposedHelpers.findClass(CLASS_DEVICE_UTIL, lpparam.classLoader), "getUUID", new XC_MethodHook() {
            @Override
            protected void afterHookedMethod(MethodHookParam param) throws Throwable {
                String originUUID = param.getResult().toString();
                String newUUID = "ffffffff-f64a-fc73-ffff-ffffca01fdf4";
                param.setResult(newUUID);
                XPoseDebugUnit.xPoseLogInfo("originUUID=" + originUUID + " replace newUUID=" + newUUID);
                super.afterHookedMethod(param);
            }
        });

        /*
         * Hook 多卡寶通知推送的通知
         */
        XposedHelpers.findAndHookMethod(XposedHelpers.findClass(CLASS_SIP_PHONE_UTIL, lpparam.classLoader), "saveMissedMms",
                ContentValues.class, String.class, Map.class, String.class, boolean.class, boolean.class, boolean.class, new XC_MethodHook() {
                    @Override
                    protected void beforeHookedMethod(MethodHookParam param) throws Throwable {

                        mContext = AndroidAppHelper.currentApplication();

                        XPoseDebugUnit.xPoseLogInfo("Success Hook Method");
                        ContentValues contentValues = (ContentValues) param.args[0];

                        String number = contentValues.getAsString("number");
                        String imsi = contentValues.getAsString("imsi");
                        String text = contentValues.getAsString("text");
                        String status = contentValues.getAsString("status");
                        String msgFrom = contentValues.getAsString("msgFrom");
                        String time = contentValues.getAsString("time");
                        String isGroup = contentValues.getAsString("isGroup");
                        String isRead = contentValues.getAsString("isRead");
                        String isDelete = contentValues.getAsString("isDelete");
                        String token = contentValues.getAsString("token");
                        String businessType = contentValues.getAsString("businessType");
                        String ext = contentValues.getAsString("ext");
                        String countryCode = contentValues.getAsString("countryCode");
                        String normalizedNumber = contentValues.getAsString("normalizedNumber");

                        String sMsg =
                                mNumber + ": " + number + "\n" +
                                        mImsi + ": " + imsi + "\n" +
                                        mText + ": " + text + "\n" +
                                        mStatus + ": " + status + "\n" +
                                        mMsgFrom + ": " + msgFrom + "\n" +
                                        mTime + ": " + time + "\n" +
                                        mIsGroup + ": " + isGroup + "\n" +
                                        mIsRead + ": " + isRead + "\n" +
                                        mIsDelete + ": " + isDelete + "\n" +
                                        mToken + ": " + token + "\n" +
                                        mBusinessType + ": " + businessType + "\n" +
                                        mExt + ": " + ext + "\n" +
                                        mCountryCode + ": " + countryCode + "\n" +
                                        mNormalizedNumber + ": " + normalizedNumber + "\n";
                        XPoseDebugUnit.xPoseLogInfo(sMsg);


                        String documentPath = "logSimbox/" + number + "-" + imsi;
                        String fileName = "SimBoxLog_" + DateUnit.INSTANCE.getNowTime("yyyy-MM-dd HH-mm-ss") + ".txt";
                        LogSaveUnit.INSTANCE.saveLogFile(mContext, documentPath, fileName, sMsg);   //存在手机外部空间
                        super.beforeHookedMethod(param);
                    }
                });
    }
}
