package com.go.hookNotify.units

import android.annotation.SuppressLint
import android.content.Context
import android.net.Uri
import android.os.Build
import android.os.Environment
import android.provider.MediaStore
import android.text.TextUtils
import android.util.Log
import java.io.*
import java.lang.StringBuilder
import java.text.SimpleDateFormat
import java.util.*

object LogSaveUnit {

    fun saveLogFile(documentPath: String, sContent: String) {
        val sdf = SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault())
        val calendar = Calendar.getInstance()
        val data = calendar.time
        val sTime = sdf.format(data)

        val fileName = "$sTime.txt"

        val destFile = File(
            "${Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DOWNLOADS)}/$documentPath/",
            fileName
        )

        save(destFile, sContent)
    }

    private fun save(file: File, content: String): Boolean {
        if (!createFile(file, true)) {
            Log.e("FileSaveUtil", "create or delete file <\$file> failed.")
            return false
        }
        var outStream: FileOutputStream? = null
        var ret: Boolean
        try {
            outStream = FileOutputStream(file)
            outStream.write(content.toByteArray())
            outStream.flush()
            ret = true
        } catch (e: Exception) {
            e.printStackTrace()
            ret = false
        } finally {
            try {
                outStream?.close()
            } catch (e: IOException) {
                // ignore
            }
        }
        return ret
    }

    private fun createFile(file: File?, isDeleteOldFile: Boolean): Boolean {
        if (file == null) return false
        if (file.exists()) {
            if (isDeleteOldFile) {
                if (!file.delete()) return false
            } else return file.isFile
        }
        return if (!createDir(file.parentFile)) false else try {
            file.createNewFile()
        } catch (e: IOException) {
            false
        }
    }

    private fun createDir(file: File?): Boolean {
        if (file == null) return false
        return if (file.exists()) file.isDirectory else file.mkdirs()
    }


}