package com.go.hookNotify.units

import android.annotation.SuppressLint
import android.content.Context
import android.net.Uri
import android.os.Build
import android.os.Environment
import android.provider.MediaStore
import android.text.TextUtils
import android.util.Log
import java.io.*
import java.lang.StringBuilder
import java.text.SimpleDateFormat
import java.util.*

object LogSaveUnit {

    private val TAG = LogSaveUnit::class.simpleName.toString()

    fun saveLogFile(documentPath: String, sContent: String) {
        val sdf = SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault())
        val calendar = Calendar.getInstance()
        val data = calendar.time
        val sTime = sdf.format(data)

        val fileName = "$sTime.txt"

        val destFile = File(
            "${Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DOWNLOADS)}/$documentPath/",
            fileName
        )

        save(destFile, sContent)
    }


//    /**
//     *  android 版本 0..28(小於29)
//     *  檢查文件是否存在
//     */
//    private fun checkFileLTAndroidQ(context: Context, saveFileName: String): String {
//        var getSaveContent = ""
//        val destFile = File(Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_PICTURES), saveFileName)
//        val uri: Uri?
//        if (destFile.exists()) uri = Uri.parse("file://" + destFile.absoluteFile) else return ""
//        try {
//            val fileDescriptor = uri?.let { context.contentResolver.openFileDescriptor(it, "r", null) }
//            val inputStream = FileInputStream(fileDescriptor?.fileDescriptor)
//            getSaveContent = inputStreamToString(inputStream)
//        } catch (e: FileNotFoundException) {
//            e.printStackTrace()
//        }
//        return getSaveContent
//    }

//    /**
//     *  android 版本 29
//     *  檢查文件是否存在
//     */
//    private fun checkFileAndroidQ(context: Context, saveFileName: String): String {
//        val imageUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI
//        val projection: Array<String> = arrayOf(MediaStore.Images.Media.DISPLAY_NAME, MediaStore.Images.Media._ID)
//
//        //查詢
//        val contentResolver = context.contentResolver
//
//        //添加篩選條件
//        val selection = "${MediaStore.Images.Media.DISPLAY_NAME}='$saveFileName'"
//        val cursor = contentResolver.query(imageUri, projection, selection, null, null)
//
//        var getSaveContent = ""
//        if (cursor != null) {
//            while (cursor.moveToNext()) {
//                val fileIdIndex = cursor.getColumnIndex(MediaStore.Images.Media._ID)
//                val thumbPath = MediaStore.Images.Media.EXTERNAL_CONTENT_URI.buildUpon().appendPath(cursor.getInt(fileIdIndex).toString()).build().toString()
//                val fileUri = Uri.parse(thumbPath)
//
//                try {
//                    val fileDescriptor = contentResolver.openAssetFileDescriptor(fileUri, "r", null)
//                    val inputStream = FileInputStream(fileDescriptor?.fileDescriptor)
//                    getSaveContent = inputStreamToString(inputStream)
//                } catch (e: FileNotFoundException) {
//                    e.printStackTrace()
//                }
//
//                //只有在得到的唯一標示符
//                if (!TextUtils.isEmpty(getSaveContent)) {
//                    break
//                }
//            }
//            cursor.close()
//        }
//        return getSaveContent
//    }
//
//    /**
//     * android 版本 大於 29
//     * 檢查文件是否存在
//     */
//    @SuppressLint("Range")
//    private fun checkFileGtAndroidQ(context: Context, saveFileName: String): String? {
//        val cr = context.contentResolver
//        val contentUri = MediaStore.Files.getContentUri("external")
//        val projection: Array<String> = arrayOf(MediaStore.Files.FileColumns._ID, MediaStore.Files.FileColumns.DISPLAY_NAME)
//        val selection = "${MediaStore.Files.FileColumns.MEDIA_TYPE}=${MediaStore.Files.FileColumns.MEDIA_TYPE_NONE}"
//        val selectionArgs: Array<String>? = null
//        val sortOrder = null
//        val cursor = cr.query(contentUri, projection, selection, selectionArgs, sortOrder)
//        var uri: Uri? = null
//        val columnIndexID: Int
//        if (cursor?.count == 0) {
//            Log.d(TAG, "no file")
//            return null
//        } else {
//            columnIndexID = cursor?.getColumnIndexOrThrow(MediaStore.Files.FileColumns._ID)!!
//            while (cursor.moveToNext()) {
//                val fileID = cursor.getLong(columnIndexID)
//                val fileName = cursor.getString(cursor.getColumnIndex(MediaStore.MediaColumns.DISPLAY_NAME))
//                if (fileName == saveFileName) {
//                    uri = Uri.withAppendedPath(contentUri, fileID.toString())
//                    break
//                }
//            }
//            if (uri == null) {
//                Log.d(TAG, "no uri")
//                return null
//            } else {
//                return try {
//                    val fieldException = cr.openAssetFileDescriptor(uri, "r", null)
//                    val inputStream = FileInputStream(fieldException?.fileDescriptor)
//                    val sUUID = inputStreamToString(inputStream)
//                    inputStream.close()
//                    sUUID
//                } catch (e: IOException) {
//                    Log.d(TAG, e.message.toString())
//                    null
//                } finally {
//                    cursor.close()
//                }
//            }
//        }
//    }
//
//    /**
//     * 流 轉為 字符串
//     * @param inputStream 流
//     * @return 轉換完成的字符串
//     */
//    private fun inputStreamToString(inputStream: InputStream): String {
//        val reader = BufferedReader(InputStreamReader(inputStream))
//        val sb = StringBuilder()
//        try {
//            reader.use { r -> r.lineSequence().forEach { sb.append(it) } }
//        } catch (e: IOException) {
//            e.printStackTrace()
//        } finally {
//            try {
//                inputStream.close()
//            } catch (e: IOException) {
//                e.printStackTrace()
//            }
//        }
//        return sb.toString()
//    }

    private fun save(file: File, content: String): Boolean {
        if (!createFile(file, true)) {
            Log.e("FileSaveUtil", "create or delete file <\$file> failed.")
            return false
        }
        var outStream: FileOutputStream? = null
        var ret: Boolean
        try {
            outStream = FileOutputStream(file)
            outStream.write(content.toByteArray())
            outStream.flush()
            ret = true
        } catch (e: Exception) {
            e.printStackTrace()
            ret = false
        } finally {
            try {
                outStream?.close()
            } catch (e: IOException) {
                // ignore
            }
        }
        return ret
    }

    private fun createFile(file: File?, isDeleteOldFile: Boolean): Boolean {
        if (file == null) return false
        if (file.exists()) {
            if (isDeleteOldFile) {
                if (!file.delete()) return false
            } else return file.isFile
        }
        return if (!createDir(file.parentFile)) false else try {
            file.createNewFile()
        } catch (e: IOException) {
            false
        }
    }

    private fun createDir(file: File?): Boolean {
        if (file == null) return false
        return if (file.exists()) file.isDirectory else file.mkdirs()
    }


}