package com.go.hookNotify

import android.app.Application
import android.os.Handler
import android.os.Looper

class MyApp : Application() {

    companion object {

        private lateinit var instance: MyApp
        fun getInstance() = instance

        private val mHandler = Handler(Looper.myLooper()!!)

        fun runOnUiThread(runnable: Runnable) {
            if (Thread.currentThread() == Looper.getMainLooper().thread) {
                runnable.run()
            } else {
                mHandler.post(runnable)
            }
        }
    }

    init {
        instance = this
    }


}