package com.go.hookNotify.xp

import com.go.hookNotify.units.XPoseDebugUnit
import com.go.hookNotify.xp.code.HookGlobalNotify
import com.go.hookNotify.xp.code.HookSimBoxNotify
import de.robv.android.xposed.IXposedHookLoadPackage
import de.robv.android.xposed.callbacks.XC_LoadPackage

class Hook : IXposedHookLoadPackage {

    @Throws(Throwable::class)
    override fun handleLoadPackage(lpparam: XC_LoadPackage.LoadPackageParam?) {
        val packageName = lpparam?.packageName.toString()
        androidSystemHook(lpparam)
        if (packageName == Constants.ANDROID) return
        xPosedHook(packageName, lpparam)
    }

    private fun androidSystemHook(loadPackageParam: XC_LoadPackage.LoadPackageParam?) {
        XPoseDebugUnit.xPoseLogDebug("android system start")
        HookGlobalNotify().handleLoadPackage(loadPackageParam)
    }

    private fun xPosedHook(packageName: String, loadPackageParam: XC_LoadPackage.LoadPackageParam?) {
        when (packageName) {
            Constants.SIMBOX_NAME -> {
                XPoseDebugUnit.xPoseLogDebug("simbox success")
                HookSimBoxNotify().handleLoadPackage(loadPackageParam)
            }
        }
    }

}