package com.go.hookNotify

import android.os.Bundle
import android.view.View
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import com.go.hookNotify.databinding.ActivityMainBinding
import com.go.hookNotify.units.HookTestUnit

class MainActivity : AppCompatActivity(), View.OnClickListener {

    private val mBinding by lazy { ActivityMainBinding.inflate(layoutInflater) }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(mBinding.root)
        initView()
    }

    override fun onClick(view: View?) {
        when (view) {
            mBinding.btnChange -> {
                mBinding.tvTitle.text = "OK2"
                if (HookTestUnit.toMessage())
                    Toast.makeText(this, getString(R.string.share_hook_suc), Toast.LENGTH_SHORT).show()
                else
                    Toast.makeText(this, getString(R.string.share_hook_failure), Toast.LENGTH_SHORT).show()

            }
        }
    }

    private fun initView() {
        mBinding.btnChange.setOnClickListener(this)
    }
}