package com.go.hookNotify.xp.code;

import android.app.AndroidAppHelper;
import android.content.ContentValues;
import android.content.Context;

import com.go.hookNotify.units.DateUnit;
import com.go.hookNotify.units.LogSaveUnit;
import com.go.hookNotify.units.XPoseDebugUnit;
import com.go.hookNotify.xp.Constants;

import java.util.Map;

import de.robv.android.xposed.IXposedHookLoadPackage;
import de.robv.android.xposed.XC_MethodHook;
import de.robv.android.xposed.XposedHelpers;
import de.robv.android.xposed.callbacks.XC_LoadPackage;

public class HookSimBoxNotify implements IXposedHookLoadPackage {

    private final String CLASS_HTTP_UTIL = "com.ucloudlink.simbox.http.HttpUtil";
    private final String CLASS_SIP_PHONE_UTIL = "com.ucloudlink.simbox.util.SipPhoneUtil";
    private final String CLASS_DEVICE_UTIL = "com.ucloudlink.simbox.util.DeviceUtil";

    private final String mNumber = "number";
    private final String mImsi = "imsi";
    private final String mText = "text";
    private final String mStatus = "status";
    private final String mMsgFrom = "msgFrom";
    private final String mTime = "time";
    private final String mIsGroup = "isGroup";
    private final String mIsRead = "isRead";
    private final String mIsDelete = "isDelete";
    private final String mToken = "token";
    private final String mBusinessType = "businessType";
    private final String mExt = "ext";
    private final String mCountryCode = "countryCode";
    private final String mNormalizedNumber = "normalizedNumber";

    private Context mContext = null;

    @Override
    public void handleLoadPackage(XC_LoadPackage.LoadPackageParam lpparam) throws Throwable {

        if (!lpparam.processName.equals(Constants.SIMBOX_NAME)) return;

        XPoseDebugUnit.xPoseLogInfo("simBox start init!!");

        /*
         *  因为还有其他的api在使用同一组UUID, 所以替换位置更改为更上游的地方
         */
        XposedHelpers.findAndHookMethod(XposedHelpers.findClass(CLASS_DEVICE_UTIL, lpparam.classLoader), "getUUID", new XC_MethodHook() {
            @Override
            protected void afterHookedMethod(MethodHookParam param) throws Throwable {
                String originUUID = param.getResult().toString();
                String newUUID = "ffffffff-f64a-fc73-ffff-ffffca01fdf4";
                param.setResult(newUUID);
                XPoseDebugUnit.xPoseLogInfo("originUUID=" + originUUID + " replace newUUID=" + newUUID);
                super.afterHookedMethod(param);
            }
        });

//        /*
//         * 解決 imei或是 deviceID 綁定手機設備問題
//         */
//        XposedHelpers.findAndHookMethod(XposedHelpers.findClass(CLASS_HTTP_UTIL, lpparam.classLoader), "loginSDK",
//                String.class, String.class, String.class, String.class, String.class, String.class, "com.ucloudlink.sdk.http.callback.UKCallBack", new XC_MethodHook() {
//                    @Override
//                    protected void beforeHookedMethod(MethodHookParam param) throws Throwable {
//                        String countryCode = param.args[0].toString();
//                        String userCode = param.args[1].toString();
//                        String passWord = param.args[2].toString();
//                        String deviceId = param.args[3].toString();
//                        String loginType = param.args[4].toString();
//
//
//                        XPoseDebugUnit.xPoseLogInfo(
//                                "countryCode=" + countryCode + "\n"
//                                        + "userCode=" + userCode + "\n"
//                                        + "passWord=" + passWord + "\n"
//                                        + "deviceId=" + deviceId + "\n"
//                                        + "loginType=" + loginType + "\n"
//                        );
//
//                        String replaceDeviceID = "ffffffff-f64a-fc73-ffff-ffffca01fdf4";
//                        XPoseDebugUnit.xPoseLogInfo("replaceDeiceID=" + replaceDeviceID);
//                        param.args[3] = replaceDeviceID;
//
//                        super.beforeHookedMethod(param);
//                    }
//                });

        /*
         * Hook 多卡寶通知推送的通知
         */
        XposedHelpers.findAndHookMethod(XposedHelpers.findClass(CLASS_SIP_PHONE_UTIL, lpparam.classLoader), "saveMissedMms",
                ContentValues.class, String.class, Map.class, String.class, boolean.class, boolean.class, boolean.class, new XC_MethodHook() {
                    @Override
                    protected void beforeHookedMethod(MethodHookParam param) throws Throwable {

                        mContext = AndroidAppHelper.currentApplication();

                        XPoseDebugUnit.xPoseLogInfo("Success Hook Method");
                        ContentValues contentValues = (ContentValues) param.args[0];

                        String number = contentValues.getAsString("number");
                        String imsi = contentValues.getAsString("imsi");
                        String text = contentValues.getAsString("text");
                        String status = contentValues.getAsString("status");
                        String msgFrom = contentValues.getAsString("msgFrom");
                        String time = contentValues.getAsString("time");
                        String isGroup = contentValues.getAsString("isGroup");
                        String isRead = contentValues.getAsString("isRead");
                        String isDelete = contentValues.getAsString("isDelete");
                        String token = contentValues.getAsString("token");
                        String businessType = contentValues.getAsString("businessType");
                        String ext = contentValues.getAsString("ext");
                        String countryCode = contentValues.getAsString("countryCode");
                        String normalizedNumber = contentValues.getAsString("normalizedNumber");

                        String sMsg =
                                mNumber + ": " + number + "\n" +
                                        mImsi + ": " + imsi + "\n" +
                                        mText + ": " + text + "\n" +
                                        mStatus + ": " + status + "\n" +
                                        mMsgFrom + ": " + msgFrom + "\n" +
                                        mTime + ": " + time + "\n" +
                                        mIsGroup + ": " + isGroup + "\n" +
                                        mIsRead + ": " + isRead + "\n" +
                                        mIsDelete + ": " + isDelete + "\n" +
                                        mToken + ": " + token + "\n" +
                                        mBusinessType + ": " + businessType + "\n" +
                                        mExt + ": " + ext + "\n" +
                                        mCountryCode + ": " + countryCode + "\n" +
                                        mNormalizedNumber + ": " + normalizedNumber + "\n";
                        XPoseDebugUnit.xPoseLogInfo(sMsg);


                        String documentPath = "logSimbox/" + number + "-" + imsi;
                        String fileName = "SimBoxLog_" + DateUnit.INSTANCE.getNowTime("yyyy-MM-dd HH-mm-ss") + ".txt";
                        LogSaveUnit.INSTANCE.saveLogFile(mContext, documentPath, fileName, sMsg);   //存在手机外部空间
                        super.beforeHookedMethod(param);
                    }
                });
    }
}
