package com.ost.micro.provider.controller;

import com.ost.micro.common.aop.DataToUnderline;
import com.ost.micro.core.context.model.response.DataResponse;
import com.ost.micro.modules.form.EditForm;
import com.ost.micro.modules.form.EditPayApiRateForm;
import com.ost.micro.modules.sys.dto.MchPayApiDto;
import com.ost.micro.modules.sys.dto.MchPayApiTmplDto;
import com.ost.micro.modules.sys.dto.MchPayDto;
import com.ost.micro.modules.sys.dto.MchPaySupplierDto;
import com.ost.micro.modules.sys.request.EditPayApiRateDto;
import com.ost.micro.modules.sys.request.MchPayBankDtoExt;
import com.ost.micro.core.utils.ResponseUtils;
import com.ost.micro.provider.common.PaymentServiceClient;
import com.ost.micro.provider.common.ServiceUrl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryClient;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping("/provider/supplier")
@Api(tags = "支付供应商接口")
public class SupplierController {

    @Autowired
    private PaymentServiceClient paymentServiceClient;
    @Autowired
    private ConsulDiscoveryClient consulDiscoveryClient;
    @Autowired
    private ServiceUrl serviceUrl;

    private String url = null;// 支付供应商上
    private String merchantUrl = null;// 商户
    private String payCashierMerchantUrl = null;// 商户
    // private String merchantPayInfoUrl =
    // ServiceUrl.INSTACE.getUrl(consulDiscoveryClient)+"/api/supplier/merchant/payinfo";//商户详情
    private String bankUrl = null;// 银行
    private String tmlpUrl = null;// 支付接口模板
    private String payapiUrl = null;// 支付接口模板
    private String cashierPayapiUrl = null;// 支付接口模板

    @GetMapping("")
    @ApiOperation("查询供应商列表")
    @ApiImplicitParams({
            @ApiImplicitParam(paramType = "query", name = "comp_id", value = "签约公司", required = false, dataType = "String"),
            @ApiImplicitParam(paramType = "query", name = "name", value = "关键字", required = false, dataType = "String"),
            @ApiImplicitParam(paramType = "query", name = "type", value = "供应商类型", required = false, dataType = "int"),
            @ApiImplicitParam(paramType = "query", name = "status", value = "启用状态", required = false, dataType = "int"),
            @ApiImplicitParam(paramType = "query", name = "page_index", value = "页码", required = true, dataType = "int"),
            @ApiImplicitParam(paramType = "query", name = "page_size", value = "每页数码条数", required = true, dataType = "int")})
    @DataToUnderline()
    public DataResponse search(@RequestParam(required = false) String name,
                               @RequestParam(required = false, name = "comp_id") String compId,
                               @RequestParam(required = false) Integer type,
                               @RequestParam(required = false) Integer status,
                               @RequestParam(name = "page_index") Integer pageIndex,
                               @RequestParam(name = "page_size") Integer pageSize) {
        url = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/supplier";
        Map params = new HashMap();
        params.put("name", name);
        params.put("type", type);
        params.put("status", status);
        params.put("pageIndex", pageIndex);
        params.put("pageSize", pageSize);
        params.put("compId", compId);
        return paymentServiceClient.get(url, params);
    }

    @PostMapping("")
    @ApiOperation("添加支付供应商")
    @DataToUnderline()
    public DataResponse add(@RequestBody(required = false) MchPaySupplierDto params) {
        url = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/supplier";
        return paymentServiceClient.post(url, params);
    }

    @GetMapping("{id}")
    @ApiOperation("支付供应商详情")
    @ApiImplicitParam(paramType = "path", name = "id", value = "支付供应商_id", required = true, dataType = "Long")
    @DataToUnderline()
    public DataResponse detail(@PathVariable Long id) {
        url = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/supplier";
        return paymentServiceClient.get(url, id);
    }

    @DeleteMapping("{id}")
    @ApiOperation("删除支付供应商")
    @ApiImplicitParam(paramType = "path", name = "id", value = "支付供应商_id", required = true, dataType = "Long")
    @DataToUnderline()
    public DataResponse delete(@PathVariable Long id) {
        url = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/supplier";
        paymentServiceClient.delete(url, id);
        return ResponseUtils.getInstance().success(null);
    }

    @PutMapping("")
    @ApiOperation("编辑支付供应商")
    @DataToUnderline()
    public DataResponse edit(@RequestBody EditForm editForm) {
        url = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/supplier";
        return paymentServiceClient.putForEntity(url, editForm);
        // return ResponseUtils.getInstance().success(null);
    }

    @GetMapping("merchant")
    @ApiOperation("查询商户列表")
    @ApiImplicitParams({
            @ApiImplicitParam(paramType = "query", name = "sup_id", value = "供应商id", required = false, dataType = "Long"),
            @ApiImplicitParam(paramType = "query", name = "keyword", value = "关键字", required = false, dataType = "String"),
            @ApiImplicitParam(paramType = "query", name = "is_entry_info", value = "是否是资质录入员", required = false, dataType = "int"),
            @ApiImplicitParam(paramType = "query", name = "is_entry_info_admin", value = "是否是资质录入员admin", required = false, dataType = "int"),
            @ApiImplicitParam(paramType = "query", name = "biz_id_admin", value = "商户商家id", required = false, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "is_biz_id_from_permission", value = "bizId是否是权限系统中", required = false, dataType = "boolean"),
            @ApiImplicitParam(paramType = "query", name = "biz_id", value = "商家id", required = false, dataType = "Long"),
            @ApiImplicitParam(paramType = "query", name = "biz_ids", value = "商家id", required = false, allowMultiple = true, dataType = "String"),
            @ApiImplicitParam(paramType = "query", name = "enable", value = "启用状态", required = false, dataType = "int"),
            @ApiImplicitParam(paramType = "query", name = "page_index", value = "页码", required = true, dataType = "int"),
            @ApiImplicitParam(paramType = "query", name = "page_size", value = "每页数码条数", required = true, dataType = "int")})
    @DataToUnderline()
    public DataResponse searchMerchant(@RequestParam(required = false, name = "sup_id") Long supId,
                                       @RequestParam(required = false) String keyword,
                                       @RequestParam(required = false, name = "is_entry_info") Integer isEntryInfo,
                                       @RequestParam(required = false, name = "is_entry_info_admin") Integer isEntryInfoAdmin,
                                       @RequestParam(required = false, name = "is_biz_id_from_permission") Boolean isBizIdFromPermission,
                                       @RequestParam(required = false, name = "biz_id") Long bizId,
                                       @RequestParam(required = false, name = "biz_id_admin") Long bizIdAdmin,
                                       @RequestParam(required = false, name = "biz_ids") String[] bizIds,
                                       @RequestParam(required = false) Integer enable,
                                       @RequestParam(name = "page_index") Integer pageIndex,
                                       @RequestParam(name = "page_size") Integer pageSize) {

        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(serviceUrl.getAsServiceUrl(consulDiscoveryClient));
        urlBuilder.append("/api/provider/supplier/merchant");
        urlBuilder.append("?supId={supId}");
        urlBuilder.append("&keyword={keyword}");
        urlBuilder.append("&isEntryInfo={isEntryInfo}");
        urlBuilder.append("&isEntryInfoAdmin={isEntryInfoAdmin}");
        urlBuilder.append("&isBizIdFromPermission={isBizIdFromPermission}");
        urlBuilder.append("&bizId={bizId}");
        urlBuilder.append("&bizIdAdmin={bizIdAdmin}");
        urlBuilder.append("&bizIds={bizIds}");
        urlBuilder.append("&enable={enable}");
        urlBuilder.append("&pageIndex={pageIndex}");
        urlBuilder.append("&pageSize={pageSize}");
        ResponseEntity<DataResponse> result = paymentServiceClient.getRestTemplate().getForEntity(urlBuilder.toString(),
                DataResponse.class, supId, keyword, isEntryInfo, isEntryInfoAdmin,isBizIdFromPermission, bizId, bizIdAdmin, bizIds, enable, pageIndex, pageSize);
        return result.getBody();

    }

    @GetMapping("merchant/info")
    @ApiOperation("获取商户详情")
    @ApiImplicitParams({
            @ApiImplicitParam(paramType = "query", name = "is_entry_info", value = "是否是资质录入员", required = false, dataType = "int"),
            @ApiImplicitParam(paramType = "query", name = "id", value = "商户id", required = true, dataType = "Long"),
            @ApiImplicitParam(paramType = "query", name = "biz_id", value = "商家id", required = false, dataType = "Long"),
            @ApiImplicitParam(paramType = "query", name = "biz_ids", value = "商家id集合", required = false, allowMultiple = true, dataType = "String")
    })
    @DataToUnderline()
    public DataResponse getMerchant(@RequestParam Long id,
                                    @RequestParam(required = false, name = "is_entry_info") Integer isEntryInfo,
                                    @RequestParam(required = false, name = "biz_id") Long bizId,
                                    @RequestParam(required = false, name = "biz_ids") String[] bizIds) {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(serviceUrl.getAsServiceUrl(consulDiscoveryClient));
        urlBuilder.append("/api/provider/supplier/merchant/info");
        urlBuilder.append("?id={id}");
        urlBuilder.append("&bizId={bizId}");
        urlBuilder.append("&bizIds={bizIds}");
        urlBuilder.append("&isEntryInfo={isEntryInfo}");
        ResponseEntity<DataResponse> result = paymentServiceClient.getRestTemplate().getForEntity(urlBuilder.toString(),
                DataResponse.class, id, bizId, bizIds, isEntryInfo);
        return result.getBody();
    }

    @PostMapping("merchant")
    @ApiOperation("添加商户")
    @DataToUnderline()
    public DataResponse add(@RequestBody(required = false) MchPayDto params, @RequestParam(required = false, name = "biz_id") Long bizId) {
        merchantUrl = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/supplier/merchant";
        params.setCreateBy(bizId + "");
        params.setSource(1);
        DataResponse dataResponse = paymentServiceClient.post(merchantUrl, params);
        return dataResponse;
    }

    @DeleteMapping("/delMerchant")
    @ApiOperation("删除商户")
    @ApiImplicitParam(paramType = "query", name = "mch_id", value = "商户id", required = true, dataType = "long")
    public DataResponse delMerchant(@RequestParam("mch_id") Long id) {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(serviceUrl.getAsServiceUrl(consulDiscoveryClient));
        urlBuilder.append("/api/provider/supplier");
        ResponseEntity<DataResponse> resp = paymentServiceClient.getRestTemplate().exchange(urlBuilder + "/delMerchant?mchId={id}", HttpMethod.DELETE, null, DataResponse.class, id);
        DataResponse dataResponse = resp.getBody();
        return dataResponse;
    }

    @PutMapping("merchant")
    @ApiOperation("编辑商户详情")
    @DataToUnderline()
    public DataResponse editMerchant(@RequestBody EditForm editForm) {
        merchantUrl = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/supplier/merchant";
        DataResponse dataResponse = paymentServiceClient.putForEntity(merchantUrl, editForm);
        return dataResponse;
    }

    @DeleteMapping("merchant/{id}")
    @ApiOperation("删除支付供应商户详情表")
    @ApiImplicitParam(paramType = "path", name = "id", value = "支付供应商户详情表_id", required = true, dataType = "Long")
    @RequiresPermissions("supplier:merchant:delete")
    public DataResponse merchantDelete(@PathVariable Long id) {
        merchantUrl = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/supplier/merchant";
        paymentServiceClient.delete(merchantUrl, id);
        return ResponseUtils.getInstance().success(null);
    }


    @GetMapping("payapi")
    @ApiOperation("查询支付接口列表")
    @ApiImplicitParams({
            @ApiImplicitParam(paramType = "query", name = "sup_id", value = "供应商id", required = false, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "api_name", value = "接口名", required = false, dataType = "String"),
            @ApiImplicitParam(paramType = "query", name = "page_index", value = "页码", required = true, dataType = "int"),
            @ApiImplicitParam(paramType = "query", name = "page_size", value = "每页数码条数", required = true, dataType = "int")})
    @DataToUnderline()
    public DataResponse searchPayapi(@RequestParam(required = false, name = "sup_id") Long supId,
                                     @RequestParam(required = false, name = "api_name") String apiName,
                                     @RequestParam(name = "page_index") Integer pageIndex,
                                     @RequestParam(name = "page_size") Integer pageSize) {
        payapiUrl = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/supplier/payapi";
        Map params = new HashMap();
        params.put("supId", supId);
        params.put("apiName", apiName);
        params.put("pageIndex", pageIndex);
        params.put("pageSize", pageSize);
        return paymentServiceClient.get(payapiUrl, params);
    }

    @GetMapping("payapi/{id}")
    @ApiOperation("获取支付接口详情")
    @ApiImplicitParam(paramType = "path", name = "id", value = "支付接口id", required = true, dataType = "long")
    @DataToUnderline()
    public DataResponse getPayapi(@PathVariable Long id) {
        payapiUrl = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/supplier/payapi";
        return paymentServiceClient.get(payapiUrl, id);
    }

    @PutMapping("/payapi")
    @ApiOperation("编辑支付接口详情")
    @RequiresPermissions("supplier:payapi:edit")
    public DataResponse editPayapi(@RequestBody MchPayApiDto mchPayApiFrom) {
        payapiUrl = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/supplier/payapi";
        paymentServiceClient.put(payapiUrl, mchPayApiFrom);
        return ResponseUtils.getInstance().success(null);
    }

    @PostMapping("/payapi")
    @ApiOperation("添加支付接口详情")
    @DataToUnderline()
    public DataResponse add(@RequestBody(required = false) MchPayApiDto params) {
        payapiUrl = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/supplier/payapi";
        DataResponse dataResponse = paymentServiceClient.post(payapiUrl, params);
        return dataResponse;
    }

    @DeleteMapping("payapi/{id}")
    @ApiOperation("删除支付接口")
    @ApiImplicitParam(paramType = "path", name = "id", value = "支付接口_id", required = true, dataType = "Long")
    @DataToUnderline()
    public DataResponse payapiDelete(@PathVariable Long id) {
        payapiUrl = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/supplier/payapi";
        paymentServiceClient.delete(payapiUrl, id);
        return ResponseUtils.getInstance().success(null);
    }

    @GetMapping("paytmpl")
    @ApiOperation("获取全部支付接口模板")
    @ApiImplicitParams({
            @ApiImplicitParam(paramType = "query", name = "page_index", value = "页码", required = true, dataType = "int"),
            @ApiImplicitParam(paramType = "query", name = "page_size", value = "每页数码条数", required = true, dataType = "int")})
    @DataToUnderline()
    public DataResponse allPaytmpl(@RequestParam(name = "page_index") Integer pageIndex, @RequestParam(name = "page_size") Integer pageSize) {
        tmlpUrl = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/supplier/paytmpl";
        Map params = new HashMap();
        params.put("pageIndex", pageIndex);
        params.put("pageSize", pageSize);
        return paymentServiceClient.get(tmlpUrl, params);
		/*Page page = paymentServiceClient.getPage(tmlpUrl, params);
		DataPager dataPager = new DataPager(pageIndex, pageSize, page.getTotal(), page.getPages());
		return ResponseUtils.getInstance().success(page.getRecords(), dataPager);*/
    }

    @PostMapping("paytmpl")
    @ApiOperation("添加支付接口模板")
    @DataToUnderline()
    public DataResponse addPaytmpl(@RequestBody(required = false) MchPayApiTmplDto params) {
        tmlpUrl = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/supplier/paytmpl";
        return paymentServiceClient.post(tmlpUrl, params);
    }

    @GetMapping("/paytmpl/{id}")
    @ApiOperation("支付接口模板详情")
    @ApiImplicitParam(paramType = "path", name = "id", value = "支付接口模板_id", required = true, dataType = "Long")
    @DataToUnderline()
    public DataResponse getPaytmpl(@PathVariable Long id) {
        tmlpUrl = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/supplier/paytmpl";
        return paymentServiceClient.get(tmlpUrl, id);
    }

    @DeleteMapping("/paytmpl/{id}")
    @ApiOperation("删除支付接口模板")
    @ApiImplicitParam(paramType = "path", name = "id", value = "支付接口模板_id", required = true, dataType = "Long")
    @DataToUnderline()
    public DataResponse deletePaytmpl(@PathVariable Long id) {
        tmlpUrl = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/supplier/paytmpl";
        paymentServiceClient.delete(tmlpUrl, id);
        return ResponseUtils.getInstance().success(null);
    }

    @PutMapping("/paytmpl")
    @ApiOperation("编辑支付接口模板")
    @DataToUnderline()
    public DataResponse editPaytmpl(@RequestBody MchPayApiTmplDto form) {
        tmlpUrl = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/supplier/paytmpl";
        paymentServiceClient.put(tmlpUrl, form);
        return ResponseUtils.getInstance().success(null);
    }

    @GetMapping("bank")
    @ApiOperation("查询银行列表")
    @ApiImplicitParams({
            @ApiImplicitParam(paramType = "query", name = "supplier_id", value = "供应商id", required = false, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "bank_name", value = "银行名", required = false, dataType = "String"),
            @ApiImplicitParam(paramType = "query", name = "enable", value = "启用状态", required = false, dataType = "String"),
            @ApiImplicitParam(paramType = "query", name = "page_index", value = "页码", required = true, dataType = "int"),
            @ApiImplicitParam(paramType = "query", name = "page_size", value = "每页数码条数", required = true, dataType = "int")})
    @DataToUnderline()
    public DataResponse searchBank(@RequestParam(required = false, name = "supplier_id") Long supplierId,
                                   @RequestParam(required = false, name = "bank_name") String bankName,
                                   @RequestParam(required = false, name = "enable") Integer enable,
                                   @RequestParam(name = "page_index") Integer pageIndex,
                                   @RequestParam(name = "page_size") Integer pageSize) {
        bankUrl = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/supplier/bank";
        Map params = new HashMap();
        params.put("supplierId", supplierId);
        params.put("bankName", bankName);
        params.put("enable", enable);
        params.put("pageIndex", pageIndex);
        params.put("pageSize", pageSize);
        return paymentServiceClient.get(bankUrl, params);

    }

    @PostMapping("bank")
    @ApiOperation("添加银行")
    @DataToUnderline()
    public DataResponse addBank(@RequestBody MchPayBankDtoExt params) {
        bankUrl = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/supplier/bank";
        return paymentServiceClient.post(bankUrl, params);
    }

    @GetMapping("bank/{id}")
    @ApiOperation("获取银行详情")
    @ApiImplicitParam(paramType = "path", name = "id", value = "银行id", required = true, dataType = "Long")
    @DataToUnderline()
    public DataResponse getBank(@PathVariable Long id) {
        bankUrl = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/supplier/bank";
        return paymentServiceClient.get(bankUrl, id);
    }

    @PutMapping("/bank")
    @ApiOperation("编辑银行详情")
    @DataToUnderline()
    public DataResponse editBank(@RequestBody MchPayBankDtoExt editForm) {
        bankUrl = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/supplier/bank";
        paymentServiceClient.put(bankUrl, editForm);
        return ResponseUtils.getInstance().success(null);
    }

    @DeleteMapping("/bank/{id}")
    @ApiOperation("删除 支付通道支持的银行")
    @ApiImplicitParam(paramType = "path", name = "id", value = " 支付通道支持的银行_id", required = true, dataType = "Long")
    @DataToUnderline()
    public DataResponse deleteBank(@PathVariable Long id) {
        bankUrl = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/supplier/bank";
        paymentServiceClient.delete(bankUrl, id);
        return ResponseUtils.getInstance().success(null);
    }

    /**
     * 设置接口费率
     *
     * @return
     */
    @PostMapping("api/rate")
    @ApiOperation("支付接口费率设置")
    @DataToUnderline()
    public DataResponse postPayApiRate(@RequestBody EditPayApiRateDto editPayApiRateForm) {
        String url = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/supplier/api/rate";
        return paymentServiceClient.post(url, editPayApiRateForm);
    }

    /**
     * 获取接口费率
     *
     * @param payApiId
     * @param rentType
     * @return
     */
    @GetMapping("api/rate")
    @ApiOperation("获取支付接口费率")
    @ApiImplicitParams({
            @ApiImplicitParam(paramType = "query", name = "pay_api_id", value = "支付接口id", required = true, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "rent_type", value = "租用方式", required = true, dataType = "int")
    })
    @DataToUnderline()
    public DataResponse getPayApiRate(@RequestParam(name = "pay_api_id") Long payApiId, @RequestParam(name = "rent_type") Integer rentType) {
        String url = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/supplier/api/rate";
        Map params = new HashMap();
        params.put("payApiId", payApiId);
        params.put("rentType", rentType);
        return paymentServiceClient.get(url, params);
    }

    /**
     * 编辑接口费率
     *
     * @param
     * @return
     */
    @PutMapping("api/rate")
    @ApiOperation("编辑支付接口费率")
    @DataToUnderline()
    public DataResponse edit(@RequestBody(required = false) EditPayApiRateForm entity) {
        String url = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/supplier/api/rate";
        return paymentServiceClient.putForEntity(url, entity);
    }


}
