package com.ost.micro.provider.controller;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.ost.micro.common.aop.DataToUnderline;
import com.ost.micro.core.context.model.response.DataResponse;
import com.ost.micro.modules.sys.dto.BizTradeDetailDto;
import com.ost.micro.modules.sys.dto.BizTradeStatisticsDto;
import com.ost.micro.modules.sys.excel.BizTradeDetailStaticBean;
import com.ost.micro.modules.sys.excel.BizTradeStatisticsBean;
import com.ost.micro.core.utils.DateUtil;
import com.ost.micro.core.utils.ExcelUtils;
import com.ost.micro.provider.common.PaymentServiceClient;
import com.ost.micro.provider.common.ServiceUrl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/provider/trade/calculate")
@Api(tags = "交易统计")
@Slf4j
public class BizTradeStaticsController {


    @Autowired
    private PaymentServiceClient paymentServiceClient;
    @Autowired
    private ConsulDiscoveryClient consulDiscoveryClient;
    @Autowired
    private ServiceUrl serviceUrl;

    private String staticUrl = null;

    @GetMapping("")
    @ApiOperation("交易统计查询")
    @ApiImplicitParams({
            @ApiImplicitParam(paramType = "query", name = "biz_id", value = "商家id", required = false, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "current_biz_id", value = "当前登录的商家id", required = false, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "is_biz_id_from_permission", value = "bizId是否是权限系统中", required = false, dataType = "boolean"),
            @ApiImplicitParam(paramType = "query", name = "biz_ids", value = "商家id", required = false, allowMultiple = true, dataType = "String"),
            @ApiImplicitParam(paramType = "query", name = "comp_id", value = "签约公司id", required = false, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "supplier_id", value = "支付供应商id", required = false, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "mch_id", value = "商户id", required = false, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "currency", value = "0人民币1美元", required = false, dataType = "int"),
            @ApiImplicitParam(paramType = "query", name = "begin_time", value = "开始时间", required = false, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "end_time", value = "结束时间", required = false, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "page_index", value = "页码", required = true, dataType = "int"),
            @ApiImplicitParam(paramType = "query", name = "page_size", value = "每页数码条数", required = true, dataType = "int")})
    @DataToUnderline()
    public DataResponse search(
            @RequestParam(required = false, name = "biz_id") Long bizId,
            @RequestParam(required = false, name = "current_biz_id") Long currentBizId,
            @RequestParam(required = false, name = "is_biz_id_from_permission") Boolean isBizIdFromPermission,
            @RequestParam(required = false, name = "biz_ids") String[] bizIds,
            @RequestParam(required = false, name = "comp_id") Long compId,
            @RequestParam(required = false, name = "supplier_id") Long supplierId,
            @RequestParam(required = false, name = "mch_id") Long mchId,
            @RequestParam(required = false, name = "begin_time") Long beginTime,
            @RequestParam(required = false, name = "end_time") Long endTime,
            @RequestParam(required = false) Integer currency,
            @RequestParam(name = "page_index") Integer pageIndex,
            @RequestParam(name = "page_size") Integer pageSize) {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(serviceUrl.getAsServiceUrl(consulDiscoveryClient));
        urlBuilder.append("/api/provider/statics");
        urlBuilder.append("?bizId={bizId}");
        urlBuilder.append("&currentBizId={currentBizId}");
        urlBuilder.append("&isBizIdFromPermission={isBizIdFromPermission}");
        urlBuilder.append("&bizIds={bizIds}");
        urlBuilder.append("&compId={compId}");
        urlBuilder.append("&supplierId={supplierId}");
        urlBuilder.append("&mchId={mchId}");
        urlBuilder.append("&beginTime={beginTime}");
        urlBuilder.append("&endTime={endTime}");
        urlBuilder.append("&currency={currency}");
        urlBuilder.append("&pageIndex={pageIndex}");
        urlBuilder.append("&pageSize={pageSize}");
        ResponseEntity<DataResponse> result = paymentServiceClient.getRestTemplate().getForEntity(urlBuilder.toString(),
                DataResponse.class, bizId, currentBizId,isBizIdFromPermission,bizIds, compId, supplierId, mchId, beginTime, endTime, currency, pageIndex, pageSize);
        return result.getBody();
    }


    /**
     * 交易明细
     *
     * @param bizId
     * @param mchId
     * @return
     */
    @GetMapping("/tradePage")
    @ApiOperation("交易统计明细")
    @ApiImplicitParams({
            @ApiImplicitParam(paramType = "query", name = "keyword", value = "商家id", required = false, dataType = "String"),
            @ApiImplicitParam(paramType = "query", name = "trade_type", value = "交易类型", required = false, dataType = "Integer"),
            @ApiImplicitParam(paramType = "query", name = "biz_id", value = "商家id", required = true, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "current_biz_id", value = "当前登录的商家id", required = false, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "is_biz_id_from_permission", value = "bizId是否是权限系统中", required = false, dataType = "boolean"),
            @ApiImplicitParam(paramType = "query", name = "mch_id", value = "商户id", required = true, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "begin_time", value = "开始时间", required = false, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "end_time", value = "结束时间", required = false, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "currency", value = "0人民币1美元", required = false, dataType = "int"),
            @ApiImplicitParam(paramType = "query", name = "page_index", value = "页码", required = true, dataType = "int"),
            @ApiImplicitParam(paramType = "query", name = "page_size", value = "每页数码条数", required = true, dataType = "int")})
    @DataToUnderline()
    public DataResponse tradePage(@RequestParam(required = false) String keyword,
                                  @RequestParam(required = false, name = "trade_type") Integer tradeType,
                                  @RequestParam(name = "biz_id") Long bizId,
                                  @RequestParam(required = false, name = "current_biz_id") Long currentBizId,
                                  @RequestParam(required = false, name = "is_biz_id_from_permission") Boolean isBizIdFromPermission,
                                  @RequestParam(name = "mch_id") Long mchId,
                                  @RequestParam(required = false, name = "begin_time") Long beginTime,
                                  @RequestParam(required = false, name = "end_time") Long endTime,
                                  @RequestParam(required = false) Integer currency,
                                  @RequestParam(name = "page_index") Integer pageIndex,
                                  @RequestParam(name = "page_size") Integer pageSize) {
        String staticUrl = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/statics/tradePage";
        Map<String, Object> params = new HashMap<>();
        params.put("keyword", keyword);
        params.put("tradeType", tradeType);
        params.put("bizId", bizId);
        params.put("currentBizId", currentBizId);
        params.put("isBizIdFromPermission", isBizIdFromPermission);
        params.put("mchId", mchId);
        params.put("beginTime", beginTime);
        params.put("endTime", endTime);
        params.put("currency", currency);
        params.put("pageIndex", pageIndex);
        params.put("pageSize", pageSize);
        return paymentServiceClient.get(staticUrl, params);
    }

    @GetMapping("/exportTradeStatic")
    @ApiOperation("导出交易统计")
    @ApiImplicitParams({
            @ApiImplicitParam(paramType = "query", name = "biz_id", value = "商家id", required = false, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "current_biz_id", value = "当前登录的商家id", required = false, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "is_biz_id_from_permission", value = "bizId是否是权限系统中", required = false, dataType = "boolean"),
            @ApiImplicitParam(paramType = "query", name = "biz_ids", value = "商家id", required = false, allowMultiple = true, dataType = "String"),
            @ApiImplicitParam(paramType = "query", name = "comp_id", value = "公司id", required = false, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "supplier_id", value = "支付供应商", required = false, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "mch_id", value = "商户id", required = false, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "begin_time", value = "开始时间", required = false, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "end_time", value = "结束时间", required = false, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "currency", value = "0人民币1美元", required = false, dataType = "int"),
            @ApiImplicitParam(paramType = "query", name = "page_index", value = "页码", required = false, dataType = "int"),
            @ApiImplicitParam(paramType = "query", name = "page_size", value = "每页数码条数", required = false, dataType = "int")})
    public void exportTradeStatic(@RequestParam(required = false, name = "biz_id") Long bizId,
                                  @RequestParam(required = false, name = "current_biz_id") Long currentBizId,
                                  @RequestParam(required = false, name = "is_biz_id_from_permission") Boolean isBizIdFromPermission,
                                  @RequestParam(required = false, name = "biz_ids") String[] bizIds,
                                  @RequestParam(required = false, name = "comp_id") Long compId,
                                  @RequestParam(required = false, name = "supplier_id") Long supplierId,
                                  @RequestParam(required = false, name = "mch_id") Long mchId,
                                  @RequestParam(required = false, name = "begin_time") Long beginTime,
                                  @RequestParam(required = false, name = "end_time") Long endTime,
                                  @RequestParam(required = false) Integer currency,
                                  @RequestParam(required = false, name = "page_index") Integer pageIndex,
                                  @RequestParam(required = false, name = "page_size") Integer pageSize,
                                  HttpServletResponse response) {

        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(serviceUrl.getAsServiceUrl(consulDiscoveryClient));
        urlBuilder.append("/api/provider/statics/exportTradeStatic");
        urlBuilder.append("?bizId={bizId}");
        urlBuilder.append("&currentBizId={currentBizId}");
        urlBuilder.append("&isBizIdFromPermission={isBizIdFromPermission}");
        urlBuilder.append("&bizIds={bizIds}");
        urlBuilder.append("&compId={compId}");
        urlBuilder.append("&supplierId={supplierId}");
        urlBuilder.append("&mchId={mchId}");
        urlBuilder.append("&beginTime={beginTime}");
        urlBuilder.append("&endTime={endTime}");
        urlBuilder.append("&currency={currency}");
        urlBuilder.append("&pageIndex={pageIndex}");
        urlBuilder.append("&pageSize={pageSize}");
        log.info("bizId={},currentBizId={},isBizIdFromPermission={}，bizIds={},compId={},supplierId={},mchId={},beginTime={},endTime={},pageIndex={},pageSize={}", bizId,currentBizId,isBizIdFromPermission,bizIds, compId, supplierId, mchId, beginTime, endTime, pageIndex, pageSize);
        ResponseEntity<DataResponse> result = paymentServiceClient.getRestTemplate().getForEntity(urlBuilder.toString(),
                DataResponse.class, bizId, currentBizId,isBizIdFromPermission,bizIds, compId, supplierId, mchId, beginTime, endTime, currency, pageIndex, pageSize);
        DataResponse dataResponse = result.getBody();
        if (null != dataResponse && null != dataResponse.getData()) {
            Object obj = dataResponse.getData().getList();
            Gson gson = new Gson();
            if (null != obj && obj instanceof List) {
                List<BizTradeStatisticsDto> dataList = gson.fromJson(gson.toJson(obj), new TypeToken<List<BizTradeStatisticsDto>>() {
                }.getType());
                try {
                    ExcelUtils.exportExcelToTarget(response, "交易统计_" + DateUtil.format(new Date(), "yyyyMMddHHmmss"), dataList, BizTradeStatisticsBean.class);
                } catch (Exception e) {
                    log.error("export 导出交易流水 error", e);
                }
            }
        }

    }

    @GetMapping("/exportTradePage")
    @ApiOperation("导出交易明细")
    @ApiImplicitParams({
            @ApiImplicitParam(paramType = "query", name = "keyword", value = "商家id", required = false, dataType = "String"),
            @ApiImplicitParam(paramType = "query", name = "trade_type", value = "交易类型", required = false, dataType = "Integer"),
            @ApiImplicitParam(paramType = "query", name = "biz_id", value = "商家id", required = true, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "current_biz_id", value = "当前登录的商家id", required = false, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "is_biz_id_from_permission", value = "bizId是否是权限系统中", required = false, dataType = "boolean"),
            @ApiImplicitParam(paramType = "query", name = "mch_id", value = "商户id", required = true, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "begin_time", value = "开始时间", required = false, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "end_time", value = "结束时间", required = false, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "currency", value = "0人民币1美元", required = false, dataType = "int"),
            @ApiImplicitParam(paramType = "query", name = "page_index", value = "页码", required = false, dataType = "int"),
            @ApiImplicitParam(paramType = "query", name = "page_size", value = "每页数码条数", required = false, dataType = "int")})
    public void exportTradePage(@RequestParam(required = false) String keyword,
                                @RequestParam(required = false, name = "trade_type") Integer tradeType,
                                @RequestParam(name = "biz_id") Long bizId,
                                @RequestParam(required = false, name = "current_biz_id") Long currentBizId,
                                @RequestParam(required = false, name = "is_biz_id_from_permission") Boolean isBizIdFromPermission,
                                @RequestParam(name = "mch_id") Long mchId,
                                @RequestParam(required = false, name = "begin_time") Long beginTime,
                                @RequestParam(required = false, name = "end_time") Long endTime,
                                @RequestParam(required = false) Integer currency,
                                @RequestParam(required = false, name = "page_index") Integer pageIndex,
                                @RequestParam(required = false, name = "page_size") Integer pageSize,
                                HttpServletResponse response) {
        String staticUrl = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/statics/exportTradePage";
        Map<String, Object> params = new HashMap<>();
        params.put("keyword", keyword);
        params.put("tradeType", tradeType);
        params.put("bizId", bizId);
        params.put("currentBizId", currentBizId);
        params.put("isBizIdFromPermission", isBizIdFromPermission);
        params.put("mchId", mchId);
        params.put("beginTime", beginTime);
        params.put("endTime", endTime);
        params.put("currency", currency);
        params.put("pageIndex", pageIndex);
        params.put("pageSize", pageSize);
        DataResponse dataResponse = paymentServiceClient.get(staticUrl, params);
        if (null != dataResponse && null != dataResponse.getData()) {
            Object obj = dataResponse.getData().getList();
            Gson gson = new Gson();
            if (null != obj && obj instanceof List) {
                List<BizTradeDetailDto> dataList = gson.fromJson(gson.toJson(obj), new TypeToken<List<BizTradeDetailDto>>() {
                }.getType());
                try {
                    ExcelUtils.exportExcelToTarget(response, "统计明细_" + DateUtil.format(new Date(), "yyyyMMddHHmmss"), dataList, BizTradeDetailStaticBean.class);
                } catch (Exception e) {
                    log.error("export 导出交易明细 error", e);
                }
            }
        }
    }
}
