package com.ost.micro.provider.controller;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.ost.micro.common.aop.DataToUnderline;
import com.ost.micro.core.context.model.response.DataResponse;
import com.ost.micro.modules.sys.dto.AuditApproveDto;
import com.ost.micro.modules.sys.dto.BizAuditmpDto;
import com.ost.micro.modules.sys.excel.BizAuditmpBean;
import com.ost.micro.core.utils.ExcelUtils;
import com.ost.micro.core.utils.ResponseUtils;
import com.ost.micro.provider.common.PaymentServiceClient;
import com.ost.micro.provider.common.ServiceUrl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/provider/audit")
@Api(tags = "审核管理接口")
@Slf4j
public class AuditController {

    @Autowired
    private PaymentServiceClient paymentServiceClient;
    @Autowired
    private ConsulDiscoveryClient consulDiscoveryClient;
    @Autowired
    private ServiceUrl serviceUrl;

    private String url = null;
//	private String url = ServiceUrl.INSTACE.getUrl(consulDiscoveryClient) + "/api/audit";// 商家审核

    @GetMapping("")
    @ApiOperation("查询审核列表")
    @ApiImplicitParams({
            @ApiImplicitParam(paramType = "query", name = "keyword", value = "关键字", required = false, dataType = "String"),
            @ApiImplicitParam(paramType = "query", name = "biz_ids", value = "商家id列表", required = false, dataType = "List"),
            @ApiImplicitParam(paramType = "query", name = "apply_type", value = "申请类型", required = false, dataType = "int"),
            @ApiImplicitParam(paramType = "query", name = "audit_status", value = "审核状态", required = false, dataType = "int"),
            @ApiImplicitParam(paramType = "query", name = "from_date", value = "起始日期", required = false, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "to_date", value = "结束日期", required = false, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "page_index", value = "页码", required = true, dataType = "int"),
            @ApiImplicitParam(paramType = "query", name = "page_size", value = "每页数码条数", required = true, dataType = "int")})
    @DataToUnderline()
    public DataResponse searchBiz(@RequestParam(required = false) String keyword,
                                  @RequestParam(required = false, name = "biz_ids") String[] bizIds,
                                  @RequestParam(required = false, name = "apply_type") Long applyType,
                                  @RequestParam(required = false, name = "audit_status") Integer auditStatus,
                                  @RequestParam(required = false, name = "from_date") Long fromDate,
                                  @RequestParam(required = false, name = "to_date") Long toDate,
                                  @RequestParam(name = "page_index") Integer pageIndex,
                                  @RequestParam(name = "page_size") Integer pageSize) {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(serviceUrl.getAsServiceUrl(consulDiscoveryClient));
        urlBuilder.append("/api/provider/audit");
        urlBuilder.append("?keyword={keyword}");
        urlBuilder.append("&bizIds={bizIds}");
        urlBuilder.append("&apply_type={applyType}");
        urlBuilder.append("&auditStatus={auditStatus}");
        urlBuilder.append("&fromDate={fromDate}");
        urlBuilder.append("&toDate={toDate}");
        urlBuilder.append("&pageIndex={pageIndex}");
        urlBuilder.append("&pageSize={pageSize}");

        ResponseEntity<DataResponse> result = paymentServiceClient.getRestTemplate()
                .getForEntity(urlBuilder.toString(), DataResponse.class, keyword, bizIds,applyType, auditStatus, fromDate, toDate, pageIndex, pageSize);
        return result.getBody();
    }

    @PutMapping("")
    @ApiOperation("审核认证资料")
    @DataToUnderline()
    public DataResponse auditCertifile(@RequestBody AuditApproveDto dto) {
        url = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/audit";
        paymentServiceClient.put(url, dto);
        return ResponseUtils.getInstance().success(null);
    }

    @GetMapping("{id}")
    @ApiOperation("认证资料详情")
    @ApiImplicitParam(paramType = "path", name = "id", value = "id", required = true, dataType = "long")
    @DataToUnderline()
    public DataResponse getCertifile(@PathVariable Long id) {
        url = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/audit";
        return paymentServiceClient.get(url, id);
    }

    /**
     * 导出
     */
    @ApiOperation("认证资料导出")
    @GetMapping("/export")
    @ApiImplicitParams({
            @ApiImplicitParam(paramType = "query", name = "keyword", value = "关键字", required = false, dataType = "String"),
            @ApiImplicitParam(paramType = "query", name = "apply_type", value = "申请类型", required = false, dataType = "int"),
            @ApiImplicitParam(paramType = "query", name = "audit_status", value = "审核状态", required = false, dataType = "int"),
            @ApiImplicitParam(paramType = "query", name = "from_date", value = "起始日期", required = false, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "to_date", value = "结束日期", required = false, dataType = "long"),
            @ApiImplicitParam(paramType = "query", name = "page_index", value = "页码", required = true, dataType = "int"),
            @ApiImplicitParam(paramType = "query", name = "page_size", value = "每页数码条数", required = true, dataType = "int")})
    public void export(@RequestParam(required = false) String keyword,
                       @RequestParam(required = false, name = "apply_type") Integer applyType,
                       @RequestParam(required = false, name = "audit_status") Integer auditStatus,
                       @RequestParam(required = false, name = "from_date") Long fromDate,
                       @RequestParam(required = false, name = "to_date") Long toDate,
                       @RequestParam(name = "page_index") Integer pageIndex,
                       @RequestParam(name = "page_size") Integer pageSize, HttpServletResponse response) {
        url = serviceUrl.getAsServiceUrl(consulDiscoveryClient) + "/api/provider/audit";
        Map params = new HashMap();
        params.put("keyword", keyword);
        params.put("applayType", applyType);
        params.put("auditStatus", auditStatus);
        params.put("fromDate", fromDate);
        params.put("toDate", toDate);
        params.put("pageIndex", pageIndex);
        params.put("pageSize", pageSize);
        DataResponse dataResponse = paymentServiceClient.get(url + "/export", params);
        if (null != dataResponse && null != dataResponse.getData()) {
            Object obj = dataResponse.getData().getList();
            Gson gson = new Gson();
            if (null != obj && obj instanceof List) {
                List<BizAuditmpDto> dataList = gson.fromJson(gson.toJson(obj), new TypeToken<List<BizAuditmpDto>>() {
                }.getType());
                try {
                    ExcelUtils.exportExcelToTarget(response, "认证资料导出", dataList, BizAuditmpBean.class);
                } catch (Exception e) {
                    log.error("export 认证资料 error", e);
                    // e.printStackTrace();
                }
            }
        }

        /* Page page = ${classname}Service.queryPage(params); */

    }
}
