/**
 * Copyright (c) 2018 人人开源 All rights reserved.
 *
 * https://www.renren.io
 *
 * 版权所有，侵权必究！
 */

package com.ost.micro.modules.security.service.impl;
import com.ost.micro.modules.security.dao.SysUserTokenDao;
import com.ost.micro.modules.security.entity.SysUserTokenEntity;
import com.ost.micro.modules.security.service.ShiroService;
import com.ost.micro.modules.security.user.UserDetail;
import com.ost.micro.modules.sys.dao.SysMenuDao;
import com.ost.micro.modules.sys.dao.SysRoleDataScopeDao;
import com.ost.micro.modules.sys.dao.SysUserDao;
import com.ost.micro.modules.sys.entity.SysUserEntity;
import com.ost.micro.modules.sys.enums.SuperAdminEnum;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Service
public class ShiroServiceImpl implements ShiroService {
    @Autowired
    private SysMenuDao sysMenuDao;
    @Autowired
    private SysUserDao sysUserDao;
    @Autowired
    private SysUserTokenDao sysUserTokenDao;
    @Autowired
    private SysRoleDataScopeDao sysRoleDataScopeDao;

    @Override
    public Set<String> getUserPermissions(UserDetail user) {
        //系统管理员，拥有最高权限
        List<String> permissionsList;
        if(user.getSuperAdmin() == SuperAdminEnum.YES.value()) {
            permissionsList = sysMenuDao.getPermissionsList();
        }else{
            permissionsList = sysMenuDao.getUserPermissionsList(user.getId());
        }

        //用户权限列表
        Set<String> permsSet = new HashSet<>();
        for(String permissions : permissionsList){
            if(StringUtils.isBlank(permissions)){
                continue;
            }
            permsSet.addAll(Arrays.asList(permissions.trim().split(",")));
        }

        return permsSet;
    }

   /* @Override
    public Set<String> getUserPermissions(UserDetail user) {
        return null;
    }*/

    @Override
    public SysUserTokenEntity getByToken(String token) {
        return sysUserTokenDao.getByToken(token);
    }

    @Override
    public SysUserEntity getUser(String userId) {
        return sysUserDao.selectById(userId);
    }

    @Override
    public List<String> getDataScopeList(String userId) {
        return sysRoleDataScopeDao.getDataScopeList(userId);
    }
}