/**
 * Copyright (c) 2018 人人开源 All rights reserved.
 *
 * https://www.renren.io
 *
 * 版权所有，侵权必究！
 */

package com.ost.micro.modules.log.excel;

import cn.afterturn.easypoi.excel.annotation.Excel;

import java.util.Date;

/**
 * 操作日志
 *
 * @author Mark sunlightcs@gmail.com
 * @since 1.0.0
 */
public class SysLogOperationExcel {
    @Excel(name = "用户操作")
    private String operation;
    @Excel(name = "请求URI")
    private String requestUri;
    @Excel(name = "请求方式")
    private String requestMethod;
    @Excel(name = "请求参数")
    private String requestParams;
    @Excel(name = "请求时长(毫秒)")
    private Integer requestTime;
    @Excel(name = "User-Agent")
    private String userAgent;
    @Excel(name = "操作IP")
    private String ip;
    @Excel(name = "状态", replace = {"失败_0", "成功_1"})
    private Integer status;
    @Excel(name = "用户名")
    private String createrName;
    @Excel(name = "创建时间", format = "yyyy-MM-dd HH:mm:ss")
    private Date createDate;

    public void setOperation(String operation) {
        this.operation = operation;
    }
    public String getOperation() {
        return operation;
    }
    public void setRequestUri(String requestUri) {
        this.requestUri = requestUri;
    }
    public String getRequestUri() {
        return requestUri;
    }
    public void setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }
    public String getRequestMethod() {
        return requestMethod;
    }
    public void setRequestParams(String requestParams) {
        this.requestParams = requestParams;
    }
    public String getRequestParams() {
        return requestParams;
    }
    public void setRequestTime(Integer requestTime) {
        this.requestTime = requestTime;
    }
    public Integer getRequestTime() {
        return requestTime;
    }
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }
    public String getUserAgent() {
        return userAgent;
    }
    public void setIp(String ip) {
        this.ip = ip;
    }
    public String getIp() {
        return ip;
    }
    public void setStatus(Integer status) {
        this.status = status;
    }
    public Integer getStatus() {
        return status;
    }
    public void setCreaterName(String createrName) {
        this.createrName = createrName;
    }
    public String getCreaterName() {
        return createrName;
    }
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }
    public Date getCreateDate() {
        return createDate;
    }
}
