package com.ost.micro.filter;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import com.ost.micro.config.CustomFilterConfig;
import com.ost.micro.core.utils.ObjectMapUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.netflix.zuul.filters.support.FilterConstants;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

@Slf4j
@Component
public class UrlFilter extends ZuulFilter {

    @Autowired
    private CustomFilterConfig customFilterConfig;

    @Override
    public String filterType() {
        return FilterConstants.PRE_TYPE ;
    }

    @Override
    public int filterOrder() {
        return 6;
    }

    @Override
    public boolean shouldFilter() {
        RequestContext ctx = RequestContext.getCurrentContext();
        HttpServletRequest request = ctx.getRequest();
        String url = request.getRequestURL().toString();
        if (null != customFilterConfig) {
            String[] urlExclude = customFilterConfig.getUrlExclude();
            if (urlExclude.length > 0) {
                for (int i=0 ;i<urlExclude.length ;i++) {
                    if (url.contains(urlExclude[i])){
                        ctx.put(FilterConstants.REQUEST_URI_KEY, request.getRequestURI());
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public Object run() throws ZuulException {
        log.info("开始进入UrlFilter zuul方法=======>");
        RequestContext ctx = RequestContext.getCurrentContext();
        HttpServletRequest request = ctx.getRequest();
        String originalRequestPath = request.getRequestURI().toString();
        String url = request.getScheme()+"://"+request.getServerName();
        log.info("request url is {}",url);
        String[] domainApis = customFilterConfig.getDomains();
        if (domainApis.length > 0) {
           for (int i=0;i<domainApis.length ; i++) {
               String itemInfo = domainApis[i];
               if (StringUtils.isNotEmpty(itemInfo)) {
                   String[] info = itemInfo.split(":");
                   String domain = info[0];
                   String serviceRote = info[1];
                   String serviceId = info[2];
                   if (url.contains(domain)) {
                       String modifiedRequestPath = "/"+serviceRote + originalRequestPath;
                       log.info("modifiedRequestPath is {}",modifiedRequestPath);
                       ctx.put(FilterConstants.REQUEST_URI_KEY, modifiedRequestPath);
                       ctx.set(FilterConstants.SERVICE_ID_KEY,serviceId);
                   }
               }
           }
        }
        return null;
    }
}
