/**
 * Copyright (c) 2018 人人开源 All rights reserved.
 *
 * https://www.renren.io
 *
 * 版权所有，侵权必究！
 */

package com.ost.micro.modules.sys.service;
import com.ost.micro.common.service.BaseService;
import com.ost.micro.modules.sys.dto.SysDeptBizDTO;
import com.ost.micro.modules.sys.dto.SysDeptDTO;
import com.ost.micro.modules.sys.entity.SysDeptEntity;

import java.util.List;
import java.util.Map;

/**
 * 部门管理
 * 
 * @author Mark sunlightcs@gmail.com
 */
public interface SysDeptService extends BaseService<SysDeptEntity> {

	List<SysDeptDTO> list(Map<String, Object> params);

	SysDeptDTO get(String id);

	void save(SysDeptDTO dto);

	void update(SysDeptDTO dto);

	void updateByCondition(SysDeptBizDTO dto);

	void delete(String id);

	/**
	 * 根据部门ID，获取本部门及子部门ID列表
	 * @param id   部门ID
	 */
	List<String> getSubDeptIdList(String id);
}