package com.ost.micro.provider.common;

import com.ost.micro.common.utils.FileUploadUtil;
import com.ost.micro.core.context.model.response.DataResponse;
import com.ost.micro.modules.sys.dto.FileUploadDto;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

/**
 * @author rain
 */
@Component
public class FileUploadController {

    @Value("${file.upload.storePath}")
    private String UPLOADED_FOLDER;
    @Value("${file.upload.urlProfix}")
    private String UPLOAD_URLPROFIX;

    public DataResponse singleFileUpload(@RequestParam("file") MultipartFile file, String type) {

        FileUploadDto fileUploadDto = FileUploadDto.builder()
                .file(file)
                .type(type)
                .storePath(UPLOADED_FOLDER)
                .urlProfix(UPLOAD_URLPROFIX)
                .build();
        return FileUploadUtil.singleFileUpload(fileUploadDto);
    }
}
